/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.framework;

import com.att.aft.dme2.internal.springframework.aop.SpringProxy;
import com.att.aft.dme2.internal.springframework.aop.framework.AdvisedSupport;
import com.att.aft.dme2.internal.springframework.aop.framework.AopConfigException;
import com.att.aft.dme2.internal.springframework.aop.framework.AopProxy;
import com.att.aft.dme2.internal.springframework.aop.framework.AopProxyFactory;
import com.att.aft.dme2.internal.springframework.aop.framework.JdkDynamicAopProxy;
import com.att.aft.dme2.internal.springframework.aop.framework.ObjenesisCglibAopProxy;
import java.io.Serializable;
import java.lang.reflect.Proxy;

public class DefaultAopProxyFactory
implements AopProxyFactory,
Serializable {
    @Override
    public AopProxy createAopProxy(AdvisedSupport config) throws AopConfigException {
        if (config.isOptimize() || config.isProxyTargetClass() || this.hasNoUserSuppliedProxyInterfaces(config)) {
            Class<?> targetClass = config.getTargetClass();
            if (targetClass == null) {
                throw new AopConfigException("TargetSource cannot determine target class: Either an interface or a target is required for proxy creation.");
            }
            if (targetClass.isInterface() || Proxy.isProxyClass(targetClass)) {
                return new JdkDynamicAopProxy(config);
            }
            return new ObjenesisCglibAopProxy(config);
        }
        return new JdkDynamicAopProxy(config);
    }

    private boolean hasNoUserSuppliedProxyInterfaces(AdvisedSupport config) {
        Class<?>[] ifcs = config.getProxiedInterfaces();
        return ifcs.length == 0 || ifcs.length == 1 && SpringProxy.class.isAssignableFrom(ifcs[0]);
    }
}

