/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.framework;

import com.att.aft.dme2.internal.apache.commons.logging.Log;
import com.att.aft.dme2.internal.apache.commons.logging.LogFactory;
import com.att.aft.dme2.internal.springframework.aop.framework.AdvisedSupport;
import com.att.aft.dme2.internal.springframework.aop.framework.AopConfigException;
import com.att.aft.dme2.internal.springframework.aop.framework.CglibAopProxy;
import com.att.aft.dme2.internal.springframework.cglib.proxy.Callback;
import com.att.aft.dme2.internal.springframework.cglib.proxy.Enhancer;
import com.att.aft.dme2.internal.springframework.cglib.proxy.Factory;
import com.att.aft.dme2.internal.springframework.objenesis.SpringObjenesis;

class ObjenesisCglibAopProxy
extends CglibAopProxy {
    private static final Log logger = LogFactory.getLog(ObjenesisCglibAopProxy.class);
    private static final SpringObjenesis objenesis = new SpringObjenesis();

    public ObjenesisCglibAopProxy(AdvisedSupport config) {
        super(config);
    }

    @Override
    protected Object createProxyClassAndInstance(Enhancer enhancer, Callback[] callbacks) {
        Class proxyClass = enhancer.createClass();
        Object proxyInstance = null;
        if (objenesis.isWorthTrying()) {
            try {
                proxyInstance = objenesis.newInstance(proxyClass, enhancer.getUseCache());
            }
            catch (Throwable ex) {
                logger.debug("Unable to instantiate proxy using Objenesis, falling back to regular proxy construction", ex);
            }
        }
        if (proxyInstance == null) {
            try {
                proxyInstance = (this.constructorArgs != null ? proxyClass.getConstructor(this.constructorArgTypes).newInstance(this.constructorArgs) : proxyClass.newInstance());
            }
            catch (Throwable ex) {
                throw new AopConfigException("Unable to instantiate proxy using Objenesis, and regular proxy instantiation via default constructor fails as well", ex);
            }
        }
        ((Factory)proxyInstance).setCallbacks(callbacks);
        return proxyInstance;
    }
}

