/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.framework;

import com.att.aft.dme2.internal.springframework.aop.framework.AopInfrastructureBean;
import com.att.aft.dme2.internal.springframework.aop.framework.ProxyConfig;
import com.att.aft.dme2.internal.springframework.aop.framework.ProxyFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.Aware;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanClassLoaderAware;
import com.att.aft.dme2.internal.springframework.beans.factory.DisposableBean;
import com.att.aft.dme2.internal.springframework.beans.factory.InitializingBean;
import com.att.aft.dme2.internal.springframework.core.Ordered;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import com.att.aft.dme2.internal.springframework.util.ObjectUtils;

public class ProxyProcessorSupport
extends ProxyConfig
implements Ordered,
BeanClassLoaderAware,
AopInfrastructureBean {
    private int order = Integer.MAX_VALUE;
    private ClassLoader proxyClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean classLoaderConfigured = false;

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setProxyClassLoader(ClassLoader classLoader) {
        this.proxyClassLoader = classLoader;
        this.classLoaderConfigured = classLoader != null;
    }

    protected ClassLoader getProxyClassLoader() {
        return this.proxyClassLoader;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        if (!this.classLoaderConfigured) {
            this.proxyClassLoader = classLoader;
        }
    }

    protected void evaluateProxyInterfaces(Class<?> beanClass, ProxyFactory proxyFactory) {
        Class<?>[] targetInterfaces = ClassUtils.getAllInterfacesForClass(beanClass, this.getProxyClassLoader());
        boolean hasReasonableProxyInterface = false;
        for (Class<?> ifc : targetInterfaces) {
            if (this.isConfigurationCallbackInterface(ifc) || this.isInternalLanguageInterface(ifc) || ifc.getMethods().length <= 0) continue;
            hasReasonableProxyInterface = true;
            break;
        }
        if (hasReasonableProxyInterface) {
            for (Class<?> ifc : targetInterfaces) {
                proxyFactory.addInterface(ifc);
            }
        } else {
            proxyFactory.setProxyTargetClass(true);
        }
    }

    protected boolean isConfigurationCallbackInterface(Class<?> ifc) {
        return InitializingBean.class == ifc || DisposableBean.class == ifc || ObjectUtils.containsElement(ifc.getInterfaces(), Aware.class);
    }

    protected boolean isInternalLanguageInterface(Class<?> ifc) {
        return ifc.getName().equals("groovy.lang.GroovyObject") || ifc.getName().endsWith(".cglib.proxy.Factory");
    }
}

