/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.framework.autoproxy;

import com.att.aft.dme2.internal.apache.commons.logging.Log;
import com.att.aft.dme2.internal.apache.commons.logging.LogFactory;
import com.att.aft.dme2.internal.springframework.aop.Advisor;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanCreationException;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanCurrentlyInCreationException;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactoryUtils;
import com.att.aft.dme2.internal.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.att.aft.dme2.internal.springframework.util.Assert;
import java.util.LinkedList;
import java.util.List;

public class BeanFactoryAdvisorRetrievalHelper {
    private static final Log logger = LogFactory.getLog(BeanFactoryAdvisorRetrievalHelper.class);
    private final ConfigurableListableBeanFactory beanFactory;
    private String[] cachedAdvisorBeanNames;

    public BeanFactoryAdvisorRetrievalHelper(ConfigurableListableBeanFactory beanFactory) {
        Assert.notNull(beanFactory, "ListableBeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Advisor> findAdvisorBeans() {
        String[] advisorNames = null;
        BeanFactoryAdvisorRetrievalHelper beanFactoryAdvisorRetrievalHelper = this;
        synchronized (beanFactoryAdvisorRetrievalHelper) {
            advisorNames = this.cachedAdvisorBeanNames;
            if (advisorNames == null) {
                this.cachedAdvisorBeanNames = advisorNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this.beanFactory, Advisor.class, true, false);
            }
        }
        if (advisorNames.length == 0) {
            return new LinkedList<Advisor>();
        }
        LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        for (String name : advisorNames) {
            if (!this.isEligibleBean(name)) continue;
            if (this.beanFactory.isCurrentlyInCreation(name)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Skipping currently created advisor '" + name + "'");
                continue;
            }
            try {
                advisors.add(this.beanFactory.getBean(name, Advisor.class));
            }
            catch (BeanCreationException ex) {
                BeanCreationException bce;
                Throwable rootCause = ex.getMostSpecificCause();
                if (rootCause instanceof BeanCurrentlyInCreationException && this.beanFactory.isCurrentlyInCreation((bce = (BeanCreationException)rootCause).getBeanName())) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Skipping advisor '" + name + "' with dependency on currently created bean: " + ex.getMessage());
                    continue;
                }
                throw ex;
            }
        }
        return advisors;
    }

    protected boolean isEligibleBean(String beanName) {
        return true;
    }
}

