/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.interceptor;

import com.att.aft.dme2.internal.apache.commons.logging.Log;
import com.att.aft.dme2.internal.apache.commons.logging.LogFactory;
import com.att.aft.dme2.internal.springframework.aop.interceptor.AsyncExecutionInterceptor;
import com.att.aft.dme2.internal.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import com.att.aft.dme2.internal.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactoryAware;
import com.att.aft.dme2.internal.springframework.beans.factory.NoSuchBeanDefinitionException;
import com.att.aft.dme2.internal.springframework.beans.factory.NoUniqueBeanDefinitionException;
import com.att.aft.dme2.internal.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import com.att.aft.dme2.internal.springframework.core.task.AsyncListenableTaskExecutor;
import com.att.aft.dme2.internal.springframework.core.task.AsyncTaskExecutor;
import com.att.aft.dme2.internal.springframework.core.task.TaskExecutor;
import com.att.aft.dme2.internal.springframework.core.task.support.TaskExecutorAdapter;
import com.att.aft.dme2.internal.springframework.lang.UsesJava8;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import com.att.aft.dme2.internal.springframework.util.ReflectionUtils;
import com.att.aft.dme2.internal.springframework.util.StringUtils;
import com.att.aft.dme2.internal.springframework.util.concurrent.ListenableFuture;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Supplier;

public abstract class AsyncExecutionAspectSupport
implements BeanFactoryAware {
    public static final String DEFAULT_TASK_EXECUTOR_BEAN_NAME = "taskExecutor";
    private static final boolean completableFuturePresent = ClassUtils.isPresent("java.util.concurrent.CompletableFuture", AsyncExecutionInterceptor.class.getClassLoader());
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<Method, AsyncTaskExecutor> executors = new ConcurrentHashMap<Method, AsyncTaskExecutor>(16);
    private volatile Executor defaultExecutor;
    private AsyncUncaughtExceptionHandler exceptionHandler;
    private BeanFactory beanFactory;

    public AsyncExecutionAspectSupport(Executor defaultExecutor) {
        this(defaultExecutor, new SimpleAsyncUncaughtExceptionHandler());
    }

    public AsyncExecutionAspectSupport(Executor defaultExecutor, AsyncUncaughtExceptionHandler exceptionHandler) {
        this.defaultExecutor = defaultExecutor;
        this.exceptionHandler = exceptionHandler;
    }

    public void setExecutor(Executor defaultExecutor) {
        this.defaultExecutor = defaultExecutor;
    }

    public void setExceptionHandler(AsyncUncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsyncTaskExecutor determineAsyncExecutor(Method method) {
        AsyncTaskExecutor executor = this.executors.get(method);
        if (executor == null) {
            Executor targetExecutor;
            String qualifier = this.getExecutorQualifier(method);
            if (StringUtils.hasLength(qualifier)) {
                targetExecutor = this.findQualifiedExecutor(this.beanFactory, qualifier);
            } else {
                targetExecutor = this.defaultExecutor;
                if (targetExecutor == null) {
                    Map<Method, AsyncTaskExecutor> map = this.executors;
                    synchronized (map) {
                        if (this.defaultExecutor == null) {
                            this.defaultExecutor = this.getDefaultExecutor(this.beanFactory);
                        }
                        targetExecutor = this.defaultExecutor;
                    }
                }
            }
            if (targetExecutor == null) {
                return null;
            }
            executor = targetExecutor instanceof AsyncListenableTaskExecutor ? (AsyncListenableTaskExecutor)targetExecutor : new TaskExecutorAdapter(targetExecutor);
            this.executors.put(method, executor);
        }
        return executor;
    }

    protected abstract String getExecutorQualifier(Method var1);

    protected Executor findQualifiedExecutor(BeanFactory beanFactory, String qualifier) {
        if (beanFactory == null) {
            throw new IllegalStateException("BeanFactory must be set on " + this.getClass().getSimpleName() + " to access qualified executor '" + qualifier + "'");
        }
        return BeanFactoryAnnotationUtils.qualifiedBeanOfType(beanFactory, Executor.class, qualifier);
    }

    protected Executor getDefaultExecutor(BeanFactory beanFactory) {
        if (beanFactory != null) {
            try {
                return beanFactory.getBean(TaskExecutor.class);
            }
            catch (NoUniqueBeanDefinitionException ex) {
                try {
                    return beanFactory.getBean(DEFAULT_TASK_EXECUTOR_BEAN_NAME, Executor.class);
                }
                catch (NoSuchBeanDefinitionException ex2) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("More than one TaskExecutor bean found within the context, and none is named 'taskExecutor'. Mark one of them as primary or name it 'taskExecutor' (possibly as an alias) in order to use it for async processing: " + ex.getBeanNamesFound());
                    }
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.logger.debug("Could not find default TaskExecutor bean", ex);
                this.logger.info("No TaskExecutor bean found for async processing");
            }
        }
        return null;
    }

    protected Object doSubmit(Callable<Object> task, AsyncTaskExecutor executor, Class<?> returnType) {
        Future<Object> result;
        if (completableFuturePresent && (result = CompletableFutureDelegate.processCompletableFuture(returnType, task, executor)) != null) {
            return result;
        }
        if (ListenableFuture.class.isAssignableFrom(returnType)) {
            return ((AsyncListenableTaskExecutor)executor).submitListenable(task);
        }
        if (Future.class.isAssignableFrom(returnType)) {
            return executor.submit(task);
        }
        executor.submit(task);
        return null;
    }

    protected void handleError(Throwable ex, Method method, Object ... params) throws Exception {
        if (Future.class.isAssignableFrom(method.getReturnType())) {
            ReflectionUtils.rethrowException(ex);
        } else {
            try {
                this.exceptionHandler.handleUncaughtException(ex, method, params);
            }
            catch (Throwable ex2) {
                this.logger.error("Exception handler for async method '" + method.toGenericString() + "' threw unexpected exception itself", ex2);
            }
        }
    }

    @UsesJava8
    private static class CompletableFutureDelegate {
        private CompletableFutureDelegate() {
        }

        public static <T> Future<T> processCompletableFuture(Class<?> returnType, final Callable<T> task, Executor executor) {
            if (!CompletableFuture.class.isAssignableFrom(returnType)) {
                return null;
            }
            return CompletableFuture.supplyAsync(new Supplier<T>(){

                @Override
                public T get() {
                    try {
                        return task.call();
                    }
                    catch (Throwable ex) {
                        throw new CompletionException(ex);
                    }
                }
            }, executor);
        }
    }
}

