/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.interceptor;

import com.att.aft.dme2.internal.aopalliance.intercept.MethodInterceptor;
import com.att.aft.dme2.internal.aopalliance.intercept.MethodInvocation;
import com.att.aft.dme2.internal.springframework.aop.interceptor.AsyncExecutionAspectSupport;
import com.att.aft.dme2.internal.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import com.att.aft.dme2.internal.springframework.aop.support.AopUtils;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.core.BridgeMethodResolver;
import com.att.aft.dme2.internal.springframework.core.Ordered;
import com.att.aft.dme2.internal.springframework.core.task.AsyncTaskExecutor;
import com.att.aft.dme2.internal.springframework.core.task.SimpleAsyncTaskExecutor;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public class AsyncExecutionInterceptor
extends AsyncExecutionAspectSupport
implements MethodInterceptor,
Ordered {
    public AsyncExecutionInterceptor(Executor defaultExecutor) {
        super(defaultExecutor);
    }

    public AsyncExecutionInterceptor(Executor defaultExecutor, AsyncUncaughtExceptionHandler exceptionHandler) {
        super(defaultExecutor, exceptionHandler);
    }

    @Override
    public Object invoke(final MethodInvocation invocation) throws Throwable {
        Class<?> targetClass = invocation.getThis() != null ? AopUtils.getTargetClass(invocation.getThis()) : null;
        Method specificMethod = ClassUtils.getMostSpecificMethod(invocation.getMethod(), targetClass);
        final Method userDeclaredMethod = BridgeMethodResolver.findBridgedMethod(specificMethod);
        AsyncTaskExecutor executor = this.determineAsyncExecutor(userDeclaredMethod);
        if (executor == null) {
            throw new IllegalStateException("No executor specified and no default executor set on AsyncExecutionInterceptor either");
        }
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Object result = invocation.proceed();
                    if (result instanceof Future) {
                        return ((Future)result).get();
                    }
                }
                catch (ExecutionException ex) {
                    AsyncExecutionInterceptor.this.handleError(ex.getCause(), userDeclaredMethod, invocation.getArguments());
                }
                catch (Throwable ex) {
                    AsyncExecutionInterceptor.this.handleError(ex, userDeclaredMethod, invocation.getArguments());
                }
                return null;
            }
        };
        return this.doSubmit(task, executor, invocation.getMethod().getReturnType());
    }

    @Override
    protected String getExecutorQualifier(Method method) {
        return null;
    }

    @Override
    protected Executor getDefaultExecutor(BeanFactory beanFactory) {
        Executor defaultExecutor = super.getDefaultExecutor(beanFactory);
        return defaultExecutor != null ? defaultExecutor : new SimpleAsyncTaskExecutor();
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

