/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.scope;

import com.att.aft.dme2.internal.springframework.aop.scope.ScopedObject;
import com.att.aft.dme2.internal.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.att.aft.dme2.internal.springframework.util.Assert;
import java.io.Serializable;

public class DefaultScopedObject
implements ScopedObject,
Serializable {
    private final ConfigurableBeanFactory beanFactory;
    private final String targetBeanName;

    public DefaultScopedObject(ConfigurableBeanFactory beanFactory, String targetBeanName) {
        Assert.notNull(beanFactory, "BeanFactory must not be null");
        Assert.hasText(targetBeanName, "'targetBeanName' must not be empty");
        this.beanFactory = beanFactory;
        this.targetBeanName = targetBeanName;
    }

    @Override
    public Object getTargetObject() {
        return this.beanFactory.getBean(this.targetBeanName);
    }

    @Override
    public void removeFromScope() {
        this.beanFactory.destroyScopedBean(this.targetBeanName);
    }
}

