/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.scope;

import com.att.aft.dme2.internal.springframework.aop.framework.AopInfrastructureBean;
import com.att.aft.dme2.internal.springframework.aop.framework.ProxyConfig;
import com.att.aft.dme2.internal.springframework.aop.framework.ProxyFactory;
import com.att.aft.dme2.internal.springframework.aop.scope.DefaultScopedObject;
import com.att.aft.dme2.internal.springframework.aop.support.DelegatingIntroductionInterceptor;
import com.att.aft.dme2.internal.springframework.aop.target.SimpleBeanTargetSource;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactoryAware;
import com.att.aft.dme2.internal.springframework.beans.factory.FactoryBean;
import com.att.aft.dme2.internal.springframework.beans.factory.FactoryBeanNotInitializedException;
import com.att.aft.dme2.internal.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import java.lang.reflect.Modifier;

public class ScopedProxyFactoryBean
extends ProxyConfig
implements FactoryBean<Object>,
BeanFactoryAware {
    private final SimpleBeanTargetSource scopedTargetSource = new SimpleBeanTargetSource();
    private String targetBeanName;
    private Object proxy;

    public ScopedProxyFactoryBean() {
        this.setProxyTargetClass(true);
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
        this.scopedTargetSource.setTargetBeanName(targetBeanName);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("Not running in a ConfigurableBeanFactory: " + beanFactory);
        }
        ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
        this.scopedTargetSource.setBeanFactory(beanFactory);
        ProxyFactory pf = new ProxyFactory();
        pf.copyFrom(this);
        pf.setTargetSource(this.scopedTargetSource);
        Class<?> beanType = beanFactory.getType(this.targetBeanName);
        if (beanType == null) {
            throw new IllegalStateException("Cannot create scoped proxy for bean '" + this.targetBeanName + "': Target type could not be determined at the time of proxy creation.");
        }
        if (!this.isProxyTargetClass() || beanType.isInterface() || Modifier.isPrivate(beanType.getModifiers())) {
            pf.setInterfaces(ClassUtils.getAllInterfacesForClass(beanType, cbf.getBeanClassLoader()));
        }
        DefaultScopedObject scopedObject = new DefaultScopedObject(cbf, this.scopedTargetSource.getTargetBeanName());
        pf.addAdvice(new DelegatingIntroductionInterceptor(scopedObject));
        pf.addInterface(AopInfrastructureBean.class);
        this.proxy = pf.getProxy(cbf.getBeanClassLoader());
    }

    @Override
    public Object getObject() {
        if (this.proxy == null) {
            throw new FactoryBeanNotInitializedException();
        }
        return this.proxy;
    }

    @Override
    public Class<?> getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        return this.scopedTargetSource.getTargetClass();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

