/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.support;

import com.att.aft.dme2.internal.aopalliance.aop.Advice;
import com.att.aft.dme2.internal.springframework.aop.support.AbstractPointcutAdvisor;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactoryAware;
import com.att.aft.dme2.internal.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.att.aft.dme2.internal.springframework.util.Assert;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class AbstractBeanFactoryPointcutAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private String adviceBeanName;
    private BeanFactory beanFactory;
    private transient Advice advice;
    private volatile transient Object adviceMonitor = new Object();

    public void setAdviceBeanName(String adviceBeanName) {
        this.adviceBeanName = adviceBeanName;
    }

    public String getAdviceBeanName() {
        return this.adviceBeanName;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.resetAdviceMonitor();
    }

    private void resetAdviceMonitor() {
        this.adviceMonitor = this.beanFactory instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)this.beanFactory).getSingletonMutex() : new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdvice(Advice advice) {
        Object object = this.adviceMonitor;
        synchronized (object) {
            this.advice = advice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Advice getAdvice() {
        Object object = this.adviceMonitor;
        synchronized (object) {
            if (this.advice == null && this.adviceBeanName != null) {
                Assert.state(this.beanFactory != null, "BeanFactory must be set to resolve 'adviceBeanName'");
                this.advice = this.beanFactory.getBean(this.adviceBeanName, Advice.class);
            }
            return this.advice;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(": advice ");
        if (this.adviceBeanName != null) {
            sb.append("bean '").append(this.adviceBeanName).append("'");
        } else {
            sb.append(this.advice);
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.resetAdviceMonitor();
    }
}

