/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.support;

import com.att.aft.dme2.internal.aopalliance.intercept.MethodInvocation;
import com.att.aft.dme2.internal.springframework.aop.DynamicIntroductionAdvice;
import com.att.aft.dme2.internal.springframework.aop.IntroductionInterceptor;
import com.att.aft.dme2.internal.springframework.aop.ProxyMethodInvocation;
import com.att.aft.dme2.internal.springframework.aop.support.AopUtils;
import com.att.aft.dme2.internal.springframework.aop.support.IntroductionInfoSupport;
import java.util.Map;
import java.util.WeakHashMap;

public class DelegatePerTargetObjectIntroductionInterceptor
extends IntroductionInfoSupport
implements IntroductionInterceptor {
    private final Map<Object, Object> delegateMap = new WeakHashMap<Object, Object>();
    private Class<?> defaultImplType;
    private Class<?> interfaceType;

    public DelegatePerTargetObjectIntroductionInterceptor(Class<?> defaultImplType, Class<?> interfaceType) {
        this.defaultImplType = defaultImplType;
        this.interfaceType = interfaceType;
        Object delegate = this.createNewDelegate();
        this.implementInterfacesOnObject(delegate);
        this.suppressInterface(IntroductionInterceptor.class);
        this.suppressInterface(DynamicIntroductionAdvice.class);
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        if (this.isMethodOnIntroducedInterface(mi)) {
            Object delegate = this.getIntroductionDelegateFor(mi.getThis());
            Object retVal = AopUtils.invokeJoinpointUsingReflection(delegate, mi.getMethod(), mi.getArguments());
            if (retVal == delegate && mi instanceof ProxyMethodInvocation) {
                retVal = ((ProxyMethodInvocation)mi).getProxy();
            }
            return retVal;
        }
        return this.doProceed(mi);
    }

    protected Object doProceed(MethodInvocation mi) throws Throwable {
        return mi.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getIntroductionDelegateFor(Object targetObject) {
        Map<Object, Object> map = this.delegateMap;
        synchronized (map) {
            if (this.delegateMap.containsKey(targetObject)) {
                return this.delegateMap.get(targetObject);
            }
            Object delegate = this.createNewDelegate();
            this.delegateMap.put(targetObject, delegate);
            return delegate;
        }
    }

    private Object createNewDelegate() {
        try {
            return this.defaultImplType.newInstance();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Cannot create default implementation for '" + this.interfaceType.getName() + "' mixin (" + this.defaultImplType.getName() + "): " + ex);
        }
    }
}

