/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.support;

import com.att.aft.dme2.internal.aopalliance.intercept.MethodInvocation;
import com.att.aft.dme2.internal.springframework.aop.DynamicIntroductionAdvice;
import com.att.aft.dme2.internal.springframework.aop.IntroductionInterceptor;
import com.att.aft.dme2.internal.springframework.aop.ProxyMethodInvocation;
import com.att.aft.dme2.internal.springframework.aop.support.AopUtils;
import com.att.aft.dme2.internal.springframework.aop.support.IntroductionInfoSupport;
import com.att.aft.dme2.internal.springframework.util.Assert;

public class DelegatingIntroductionInterceptor
extends IntroductionInfoSupport
implements IntroductionInterceptor {
    private Object delegate;

    public DelegatingIntroductionInterceptor(Object delegate) {
        this.init(delegate);
    }

    protected DelegatingIntroductionInterceptor() {
        this.init(this);
    }

    private void init(Object delegate) {
        Assert.notNull(delegate, "Delegate must not be null");
        this.delegate = delegate;
        this.implementInterfacesOnObject(delegate);
        this.suppressInterface(IntroductionInterceptor.class);
        this.suppressInterface(DynamicIntroductionAdvice.class);
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        if (this.isMethodOnIntroducedInterface(mi)) {
            Object retVal = AopUtils.invokeJoinpointUsingReflection(this.delegate, mi.getMethod(), mi.getArguments());
            if (retVal == this.delegate && mi instanceof ProxyMethodInvocation) {
                Object proxy = ((ProxyMethodInvocation)mi).getProxy();
                if (mi.getMethod().getReturnType().isInstance(proxy)) {
                    retVal = proxy;
                }
            }
            return retVal;
        }
        return this.doProceed(mi);
    }

    protected Object doProceed(MethodInvocation mi) throws Throwable {
        return mi.proceed();
    }
}

