/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.support;

import com.att.aft.dme2.internal.springframework.aop.support.StaticMethodMatcherPointcut;
import com.att.aft.dme2.internal.springframework.util.ObjectUtils;
import com.att.aft.dme2.internal.springframework.util.PatternMatchUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class NameMatchMethodPointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    private List<String> mappedNames = new LinkedList<String>();

    public void setMappedName(String mappedName) {
        this.setMappedNames(mappedName);
    }

    public void setMappedNames(String ... mappedNames) {
        this.mappedNames = new LinkedList<String>();
        if (mappedNames != null) {
            this.mappedNames.addAll(Arrays.asList(mappedNames));
        }
    }

    public NameMatchMethodPointcut addMethodName(String name) {
        this.mappedNames.add(name);
        return this;
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        for (String mappedName : this.mappedNames) {
            if (!mappedName.equals(method.getName()) && !this.isMatch(method.getName(), mappedName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch(mappedName, methodName);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NameMatchMethodPointcut && ObjectUtils.nullSafeEquals(this.mappedNames, ((NameMatchMethodPointcut)other).mappedNames);
    }

    public int hashCode() {
        return this.mappedNames != null ? this.mappedNames.hashCode() : 0;
    }
}

