/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.support;

import com.att.aft.dme2.internal.springframework.aop.MethodMatcher;
import com.att.aft.dme2.internal.springframework.aop.Pointcut;
import com.att.aft.dme2.internal.springframework.aop.support.ComposablePointcut;
import com.att.aft.dme2.internal.springframework.aop.support.StaticMethodMatcherPointcut;
import com.att.aft.dme2.internal.springframework.util.Assert;
import java.io.Serializable;
import java.lang.reflect.Method;

public abstract class Pointcuts {
    public static final Pointcut SETTERS = SetterPointcut.INSTANCE;
    public static final Pointcut GETTERS = GetterPointcut.INSTANCE;

    public static Pointcut union(Pointcut pc1, Pointcut pc2) {
        return new ComposablePointcut(pc1).union(pc2);
    }

    public static Pointcut intersection(Pointcut pc1, Pointcut pc2) {
        return new ComposablePointcut(pc1).intersection(pc2);
    }

    public static boolean matches(Pointcut pointcut, Method method, Class<?> targetClass, Object ... args) {
        MethodMatcher mm;
        Assert.notNull(pointcut, "Pointcut must not be null");
        if (pointcut == Pointcut.TRUE) {
            return true;
        }
        if (pointcut.getClassFilter().matches(targetClass) && (mm = pointcut.getMethodMatcher()).matches(method, targetClass)) {
            return !mm.isRuntime() || mm.matches(method, targetClass, args);
        }
        return false;
    }

    private static class GetterPointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        public static GetterPointcut INSTANCE = new GetterPointcut();

        private GetterPointcut() {
        }

        @Override
        public boolean matches(Method method, Class<?> targetClass) {
            return method.getName().startsWith("get") && method.getParameterTypes().length == 0;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static class SetterPointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        public static SetterPointcut INSTANCE = new SetterPointcut();

        private SetterPointcut() {
        }

        @Override
        public boolean matches(Method method, Class<?> targetClass) {
            return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

