/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.support.annotation;

import com.att.aft.dme2.internal.springframework.aop.ClassFilter;
import com.att.aft.dme2.internal.springframework.aop.MethodMatcher;
import com.att.aft.dme2.internal.springframework.aop.Pointcut;
import com.att.aft.dme2.internal.springframework.aop.support.annotation.AnnotationClassFilter;
import com.att.aft.dme2.internal.springframework.aop.support.annotation.AnnotationMethodMatcher;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.util.ObjectUtils;
import java.lang.annotation.Annotation;

public class AnnotationMatchingPointcut
implements Pointcut {
    private final ClassFilter classFilter;
    private final MethodMatcher methodMatcher;

    public AnnotationMatchingPointcut(Class<? extends Annotation> classAnnotationType) {
        this.classFilter = new AnnotationClassFilter(classAnnotationType);
        this.methodMatcher = MethodMatcher.TRUE;
    }

    public AnnotationMatchingPointcut(Class<? extends Annotation> classAnnotationType, boolean checkInherited) {
        this.classFilter = new AnnotationClassFilter(classAnnotationType, checkInherited);
        this.methodMatcher = MethodMatcher.TRUE;
    }

    public AnnotationMatchingPointcut(Class<? extends Annotation> classAnnotationType, Class<? extends Annotation> methodAnnotationType) {
        Assert.isTrue(classAnnotationType != null || methodAnnotationType != null, "Either Class annotation type or Method annotation type needs to be specified (or both)");
        this.classFilter = classAnnotationType != null ? new AnnotationClassFilter(classAnnotationType) : ClassFilter.TRUE;
        this.methodMatcher = methodAnnotationType != null ? new AnnotationMethodMatcher(methodAnnotationType) : MethodMatcher.TRUE;
    }

    @Override
    public ClassFilter getClassFilter() {
        return this.classFilter;
    }

    @Override
    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotationMatchingPointcut)) {
            return false;
        }
        AnnotationMatchingPointcut that = (AnnotationMatchingPointcut)other;
        return ObjectUtils.nullSafeEquals(that.classFilter, this.classFilter) && ObjectUtils.nullSafeEquals(that.methodMatcher, this.methodMatcher);
    }

    public int hashCode() {
        int code = 17;
        if (this.classFilter != null) {
            code = 37 * code + this.classFilter.hashCode();
        }
        if (this.methodMatcher != null) {
            code = 37 * code + this.methodMatcher.hashCode();
        }
        return code;
    }

    public String toString() {
        return "AnnotationMatchingPointcut: " + this.classFilter + ", " + this.methodMatcher;
    }

    public static AnnotationMatchingPointcut forClassAnnotation(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        return new AnnotationMatchingPointcut(annotationType);
    }

    public static AnnotationMatchingPointcut forMethodAnnotation(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        return new AnnotationMatchingPointcut(null, annotationType);
    }
}

