/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.target;

import com.att.aft.dme2.internal.springframework.aop.target.AbstractBeanFactoryBasedTargetSource;
import com.att.aft.dme2.internal.springframework.aop.target.SingletonTargetSource;
import com.att.aft.dme2.internal.springframework.beans.BeansException;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanDefinitionStoreException;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.DisposableBean;
import com.att.aft.dme2.internal.springframework.beans.factory.config.ConfigurableBeanFactory;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;

public abstract class AbstractPrototypeBasedTargetSource
extends AbstractBeanFactoryBasedTargetSource {
    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        if (!beanFactory.isPrototype(this.getTargetBeanName())) {
            throw new BeanDefinitionStoreException("Cannot use prototype-based TargetSource against non-prototype bean with name '" + this.getTargetBeanName() + "': instances would not be independent");
        }
    }

    protected Object newPrototypeInstance() throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating new instance of bean '" + this.getTargetBeanName() + "'");
        }
        return this.getBeanFactory().getBean(this.getTargetBeanName());
    }

    protected void destroyPrototypeInstance(Object target) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Destroying instance of bean '" + this.getTargetBeanName() + "'");
        }
        if (this.getBeanFactory() instanceof ConfigurableBeanFactory) {
            ((ConfigurableBeanFactory)this.getBeanFactory()).destroyBean(this.getTargetBeanName(), target);
        } else if (target instanceof DisposableBean) {
            try {
                ((DisposableBean)target).destroy();
            }
            catch (Throwable ex) {
                this.logger.error("Couldn't invoke destroy method of bean with name '" + this.getTargetBeanName() + "'", ex);
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("A prototype-based TargetSource itself is not deserializable - just a disconnected SingletonTargetSource is");
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Disconnecting TargetSource [" + this + "]");
        }
        try {
            return new SingletonTargetSource(this.getTarget());
        }
        catch (Exception ex) {
            this.logger.error("Cannot get target for disconnecting TargetSource [" + this + "]", ex);
            throw new NotSerializableException("Cannot get target for disconnecting TargetSource [" + this + "]: " + ex);
        }
    }
}

