/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.aop.target;

import com.att.aft.dme2.internal.springframework.aop.TargetSource;
import com.att.aft.dme2.internal.springframework.util.ObjectUtils;
import java.io.Serializable;

public class EmptyTargetSource
implements TargetSource,
Serializable {
    private static final long serialVersionUID = 3680494563553489691L;
    public static final EmptyTargetSource INSTANCE = new EmptyTargetSource(null, true);
    private final Class<?> targetClass;
    private final boolean isStatic;

    public static EmptyTargetSource forClass(Class<?> targetClass) {
        return EmptyTargetSource.forClass(targetClass, true);
    }

    public static EmptyTargetSource forClass(Class<?> targetClass, boolean isStatic) {
        return targetClass == null && isStatic ? INSTANCE : new EmptyTargetSource(targetClass, isStatic);
    }

    private EmptyTargetSource(Class<?> targetClass, boolean isStatic) {
        this.targetClass = targetClass;
        this.isStatic = isStatic;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public Object getTarget() {
        return null;
    }

    @Override
    public void releaseTarget(Object target) {
    }

    private Object readResolve() {
        return this.targetClass == null && this.isStatic ? INSTANCE : this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EmptyTargetSource)) {
            return false;
        }
        EmptyTargetSource otherTs = (EmptyTargetSource)other;
        return ObjectUtils.nullSafeEquals(this.targetClass, otherTs.targetClass) && this.isStatic == otherTs.isStatic;
    }

    public int hashCode() {
        return EmptyTargetSource.class.hashCode() * 13 + ObjectUtils.nullSafeHashCode(this.targetClass);
    }

    public String toString() {
        return "EmptyTargetSource: " + (this.targetClass != null ? "target class [" + this.targetClass.getName() + "]" : "no target class") + ", " + (this.isStatic ? "static" : "dynamic");
    }
}

