/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans;

import com.att.aft.dme2.internal.springframework.beans.BeansException;
import com.att.aft.dme2.internal.springframework.beans.ConfigurablePropertyAccessor;
import com.att.aft.dme2.internal.springframework.beans.MutablePropertyValues;
import com.att.aft.dme2.internal.springframework.beans.NotWritablePropertyException;
import com.att.aft.dme2.internal.springframework.beans.NullValueInNestedPathException;
import com.att.aft.dme2.internal.springframework.beans.PropertyAccessException;
import com.att.aft.dme2.internal.springframework.beans.PropertyBatchUpdateException;
import com.att.aft.dme2.internal.springframework.beans.PropertyValue;
import com.att.aft.dme2.internal.springframework.beans.PropertyValues;
import com.att.aft.dme2.internal.springframework.beans.TypeConverterSupport;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractPropertyAccessor
extends TypeConverterSupport
implements ConfigurablePropertyAccessor {
    private boolean extractOldValueForEditor = false;
    private boolean autoGrowNestedPaths = false;

    @Override
    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
        this.extractOldValueForEditor = extractOldValueForEditor;
    }

    @Override
    public boolean isExtractOldValueForEditor() {
        return this.extractOldValueForEditor;
    }

    @Override
    public void setAutoGrowNestedPaths(boolean autoGrowNestedPaths) {
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    @Override
    public boolean isAutoGrowNestedPaths() {
        return this.autoGrowNestedPaths;
    }

    @Override
    public void setPropertyValue(PropertyValue pv) throws BeansException {
        this.setPropertyValue(pv.getName(), pv.getValue());
    }

    @Override
    public void setPropertyValues(Map<?, ?> map) throws BeansException {
        this.setPropertyValues(new MutablePropertyValues(map));
    }

    @Override
    public void setPropertyValues(PropertyValues pvs) throws BeansException {
        this.setPropertyValues(pvs, false, false);
    }

    @Override
    public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown) throws BeansException {
        this.setPropertyValues(pvs, ignoreUnknown, false);
    }

    @Override
    public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown, boolean ignoreInvalid) throws BeansException {
        LinkedList<PropertyAccessException> propertyAccessExceptions = null;
        List<PropertyValue> propertyValues = pvs instanceof MutablePropertyValues ? ((MutablePropertyValues)pvs).getPropertyValueList() : Arrays.asList(pvs.getPropertyValues());
        for (PropertyValue pv : propertyValues) {
            try {
                this.setPropertyValue(pv);
            }
            catch (NotWritablePropertyException ex) {
                if (ignoreUnknown) continue;
                throw ex;
            }
            catch (NullValueInNestedPathException ex) {
                if (ignoreInvalid) continue;
                throw ex;
            }
            catch (PropertyAccessException ex) {
                if (propertyAccessExceptions == null) {
                    propertyAccessExceptions = new LinkedList<PropertyAccessException>();
                }
                propertyAccessExceptions.add(ex);
            }
        }
        if (propertyAccessExceptions != null) {
            PropertyAccessException[] paeArray = propertyAccessExceptions.toArray(new PropertyAccessException[propertyAccessExceptions.size()]);
            throw new PropertyBatchUpdateException(paeArray);
        }
    }

    @Override
    public Class<?> getPropertyType(String propertyPath) {
        return null;
    }

    @Override
    public abstract Object getPropertyValue(String var1) throws BeansException;

    @Override
    public abstract void setPropertyValue(String var1, Object var2) throws BeansException;
}

