/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans;

import com.att.aft.dme2.internal.springframework.beans.AbstractNestablePropertyAccessor;
import com.att.aft.dme2.internal.springframework.beans.BeanWrapper;
import com.att.aft.dme2.internal.springframework.beans.CachedIntrospectionResults;
import com.att.aft.dme2.internal.springframework.beans.GenericTypeAwarePropertyDescriptor;
import com.att.aft.dme2.internal.springframework.beans.InvalidPropertyException;
import com.att.aft.dme2.internal.springframework.beans.NotWritablePropertyException;
import com.att.aft.dme2.internal.springframework.beans.PropertyMatches;
import com.att.aft.dme2.internal.springframework.beans.TypeConverterDelegate;
import com.att.aft.dme2.internal.springframework.beans.TypeMismatchException;
import com.att.aft.dme2.internal.springframework.core.ResolvableType;
import com.att.aft.dme2.internal.springframework.core.convert.Property;
import com.att.aft.dme2.internal.springframework.core.convert.TypeDescriptor;
import com.att.aft.dme2.internal.springframework.util.Assert;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class BeanWrapperImpl
extends AbstractNestablePropertyAccessor
implements BeanWrapper {
    private CachedIntrospectionResults cachedIntrospectionResults;
    private AccessControlContext acc;

    public BeanWrapperImpl() {
        this(true);
    }

    public BeanWrapperImpl(boolean registerDefaultEditors) {
        super(registerDefaultEditors);
    }

    public BeanWrapperImpl(Object object) {
        super(object);
    }

    public BeanWrapperImpl(Class<?> clazz) {
        super(clazz);
    }

    public BeanWrapperImpl(Object object, String nestedPath, Object rootObject) {
        super(object, nestedPath, rootObject);
    }

    private BeanWrapperImpl(Object object, String nestedPath, BeanWrapperImpl parent) {
        super(object, nestedPath, parent);
        this.setSecurityContext(parent.acc);
    }

    public void setBeanInstance(Object object) {
        this.wrappedObject = object;
        this.rootObject = object;
        this.typeConverterDelegate = new TypeConverterDelegate(this, this.wrappedObject);
        this.setIntrospectionClass(object.getClass());
    }

    @Override
    public void setWrappedInstance(Object object, String nestedPath, Object rootObject) {
        super.setWrappedInstance(object, nestedPath, rootObject);
        this.setIntrospectionClass(this.getWrappedClass());
    }

    protected void setIntrospectionClass(Class<?> clazz) {
        if (this.cachedIntrospectionResults != null && this.cachedIntrospectionResults.getBeanClass() != clazz) {
            this.cachedIntrospectionResults = null;
        }
    }

    private CachedIntrospectionResults getCachedIntrospectionResults() {
        Assert.state(this.getWrappedInstance() != null, "BeanWrapper does not hold a bean instance");
        if (this.cachedIntrospectionResults == null) {
            this.cachedIntrospectionResults = CachedIntrospectionResults.forClass(this.getWrappedClass());
        }
        return this.cachedIntrospectionResults;
    }

    public void setSecurityContext(AccessControlContext acc) {
        this.acc = acc;
    }

    public AccessControlContext getSecurityContext() {
        return this.acc;
    }

    public Object convertForProperty(Object value, String propertyName) throws TypeMismatchException {
        CachedIntrospectionResults cachedIntrospectionResults = this.getCachedIntrospectionResults();
        PropertyDescriptor pd = cachedIntrospectionResults.getPropertyDescriptor(propertyName);
        if (pd == null) {
            throw new InvalidPropertyException(this.getRootClass(), this.getNestedPath() + propertyName, "No property '" + propertyName + "' found");
        }
        TypeDescriptor td = cachedIntrospectionResults.getTypeDescriptor(pd);
        if (td == null) {
            td = cachedIntrospectionResults.addTypeDescriptor(pd, new TypeDescriptor(this.property(pd)));
        }
        return this.convertForProperty(propertyName, null, value, td);
    }

    private Property property(PropertyDescriptor pd) {
        GenericTypeAwarePropertyDescriptor gpd = (GenericTypeAwarePropertyDescriptor)pd;
        return new Property(gpd.getBeanClass(), gpd.getReadMethod(), gpd.getWriteMethod(), gpd.getName());
    }

    @Override
    protected BeanPropertyHandler getLocalPropertyHandler(String propertyName) {
        PropertyDescriptor pd = this.getCachedIntrospectionResults().getPropertyDescriptor(propertyName);
        if (pd != null) {
            return new BeanPropertyHandler(pd);
        }
        return null;
    }

    @Override
    protected BeanWrapperImpl newNestedPropertyAccessor(Object object, String nestedPath) {
        return new BeanWrapperImpl(object, nestedPath, this);
    }

    @Override
    protected NotWritablePropertyException createNotWritablePropertyException(String propertyName) {
        PropertyMatches matches = PropertyMatches.forProperty(propertyName, this.getRootClass());
        throw new NotWritablePropertyException(this.getRootClass(), this.getNestedPath() + propertyName, matches.buildErrorMessage(), matches.getPossibleMatches());
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.getCachedIntrospectionResults().getPropertyDescriptors();
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws InvalidPropertyException {
        BeanWrapperImpl nestedBw = (BeanWrapperImpl)this.getPropertyAccessorForPropertyPath(propertyName);
        String finalPath = this.getFinalPath(nestedBw, propertyName);
        PropertyDescriptor pd = nestedBw.getCachedIntrospectionResults().getPropertyDescriptor(finalPath);
        if (pd == null) {
            throw new InvalidPropertyException(this.getRootClass(), this.getNestedPath() + propertyName, "No property '" + propertyName + "' found");
        }
        return pd;
    }

    private class BeanPropertyHandler
    extends AbstractNestablePropertyAccessor.PropertyHandler {
        private final PropertyDescriptor pd;

        public BeanPropertyHandler(PropertyDescriptor pd) {
            super(pd.getPropertyType(), pd.getReadMethod() != null, pd.getWriteMethod() != null);
            this.pd = pd;
        }

        @Override
        public ResolvableType getResolvableType() {
            return ResolvableType.forMethodReturnType(this.pd.getReadMethod());
        }

        @Override
        public TypeDescriptor toTypeDescriptor() {
            return new TypeDescriptor(BeanWrapperImpl.this.property(this.pd));
        }

        @Override
        public TypeDescriptor nested(int level) {
            return TypeDescriptor.nested(BeanWrapperImpl.this.property(this.pd), level);
        }

        @Override
        public Object getValue() throws Exception {
            final Method readMethod = this.pd.getReadMethod();
            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers()) && !readMethod.isAccessible()) {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            readMethod.setAccessible(true);
                            return null;
                        }
                    });
                } else {
                    readMethod.setAccessible(true);
                }
            }
            if (System.getSecurityManager() != null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return readMethod.invoke(BeanWrapperImpl.this.getWrappedInstance(), (Object[])null);
                        }
                    }, BeanWrapperImpl.this.acc);
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            }
            return readMethod.invoke(BeanWrapperImpl.this.getWrappedInstance(), (Object[])null);
        }

        @Override
        public void setValue(final Object object, Object valueToApply) throws Exception {
            Method writeMethod;
            Method method = writeMethod = this.pd instanceof GenericTypeAwarePropertyDescriptor ? ((GenericTypeAwarePropertyDescriptor)this.pd).getWriteMethodForActualAccess() : this.pd.getWriteMethod();
            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers()) && !writeMethod.isAccessible()) {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            writeMethod.setAccessible(true);
                            return null;
                        }
                    });
                } else {
                    writeMethod.setAccessible(true);
                }
            }
            final Object value = valueToApply;
            if (System.getSecurityManager() != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            writeMethod.invoke(object, value);
                            return null;
                        }
                    }, BeanWrapperImpl.this.acc);
                }
                catch (PrivilegedActionException ex) {
                    throw ex.getException();
                }
            } else {
                writeMethod.invoke(BeanWrapperImpl.this.getWrappedInstance(), value);
            }
        }
    }
}

