/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans;

import com.att.aft.dme2.internal.springframework.beans.AbstractNestablePropertyAccessor;
import com.att.aft.dme2.internal.springframework.beans.InvalidPropertyException;
import com.att.aft.dme2.internal.springframework.beans.NotWritablePropertyException;
import com.att.aft.dme2.internal.springframework.beans.PropertyMatches;
import com.att.aft.dme2.internal.springframework.core.ResolvableType;
import com.att.aft.dme2.internal.springframework.core.convert.TypeDescriptor;
import com.att.aft.dme2.internal.springframework.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class DirectFieldAccessor
extends AbstractNestablePropertyAccessor {
    private final Map<String, FieldPropertyHandler> fieldMap = new HashMap<String, FieldPropertyHandler>();

    public DirectFieldAccessor(Object object) {
        super(object);
    }

    protected DirectFieldAccessor(Object object, String nestedPath, DirectFieldAccessor parent) {
        super(object, nestedPath, parent);
    }

    @Override
    protected FieldPropertyHandler getLocalPropertyHandler(String propertyName) {
        FieldPropertyHandler propertyHandler = this.fieldMap.get(propertyName);
        if (propertyHandler == null) {
            Field field = ReflectionUtils.findField(this.getWrappedClass(), propertyName);
            if (field != null) {
                propertyHandler = new FieldPropertyHandler(field);
            }
            this.fieldMap.put(propertyName, propertyHandler);
        }
        return propertyHandler;
    }

    @Override
    protected DirectFieldAccessor newNestedPropertyAccessor(Object object, String nestedPath) {
        return new DirectFieldAccessor(object, nestedPath, this);
    }

    @Override
    protected NotWritablePropertyException createNotWritablePropertyException(String propertyName) {
        PropertyMatches matches = PropertyMatches.forField(propertyName, this.getRootClass());
        throw new NotWritablePropertyException(this.getRootClass(), this.getNestedPath() + propertyName, matches.buildErrorMessage(), matches.getPossibleMatches());
    }

    private class FieldPropertyHandler
    extends AbstractNestablePropertyAccessor.PropertyHandler {
        private final Field field;

        public FieldPropertyHandler(Field field) {
            super(field.getType(), true, true);
            this.field = field;
        }

        @Override
        public TypeDescriptor toTypeDescriptor() {
            return new TypeDescriptor(this.field);
        }

        @Override
        public ResolvableType getResolvableType() {
            return ResolvableType.forField(this.field);
        }

        @Override
        public TypeDescriptor nested(int level) {
            return TypeDescriptor.nested(this.field, level);
        }

        @Override
        public Object getValue() throws Exception {
            try {
                ReflectionUtils.makeAccessible(this.field);
                return this.field.get(DirectFieldAccessor.this.getWrappedInstance());
            }
            catch (IllegalAccessException ex) {
                throw new InvalidPropertyException(DirectFieldAccessor.this.getWrappedClass(), this.field.getName(), "Field is not accessible", ex);
            }
        }

        @Override
        public void setValue(Object object, Object value) throws Exception {
            try {
                ReflectionUtils.makeAccessible(this.field);
                this.field.set(object, value);
            }
            catch (IllegalAccessException ex) {
                throw new InvalidPropertyException(DirectFieldAccessor.this.getWrappedClass(), this.field.getName(), "Field is not accessible", ex);
            }
        }
    }
}

