/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans;

import com.att.aft.dme2.internal.springframework.beans.ConversionNotSupportedException;
import com.att.aft.dme2.internal.springframework.beans.PropertyEditorRegistrySupport;
import com.att.aft.dme2.internal.springframework.beans.TypeConverter;
import com.att.aft.dme2.internal.springframework.beans.TypeConverterDelegate;
import com.att.aft.dme2.internal.springframework.beans.TypeMismatchException;
import com.att.aft.dme2.internal.springframework.core.MethodParameter;
import com.att.aft.dme2.internal.springframework.core.convert.ConversionException;
import com.att.aft.dme2.internal.springframework.core.convert.ConverterNotFoundException;
import java.lang.reflect.Field;

public abstract class TypeConverterSupport
extends PropertyEditorRegistrySupport
implements TypeConverter {
    TypeConverterDelegate typeConverterDelegate;

    @Override
    public <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
        return this.doConvert(value, requiredType, null, null);
    }

    @Override
    public <T> T convertIfNecessary(Object value, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        return this.doConvert(value, requiredType, methodParam, null);
    }

    @Override
    public <T> T convertIfNecessary(Object value, Class<T> requiredType, Field field) throws TypeMismatchException {
        return this.doConvert(value, requiredType, null, field);
    }

    private <T> T doConvert(Object value, Class<T> requiredType, MethodParameter methodParam, Field field) throws TypeMismatchException {
        try {
            if (field != null) {
                return this.typeConverterDelegate.convertIfNecessary(value, requiredType, field);
            }
            return this.typeConverterDelegate.convertIfNecessary(value, requiredType, methodParam);
        }
        catch (ConverterNotFoundException ex) {
            throw new ConversionNotSupportedException(value, requiredType, (Throwable)ex);
        }
        catch (ConversionException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            throw new ConversionNotSupportedException(value, requiredType, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
    }
}

