/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.factory;

import com.att.aft.dme2.internal.springframework.beans.BeansException;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanCreationException;
import com.att.aft.dme2.internal.springframework.beans.factory.InjectionPoint;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import com.att.aft.dme2.internal.springframework.util.StringUtils;

public class UnsatisfiedDependencyException
extends BeanCreationException {
    private InjectionPoint injectionPoint;

    public UnsatisfiedDependencyException(String resourceDescription, String beanName, String propertyName, String msg) {
        super(resourceDescription, beanName, "Unsatisfied dependency expressed through bean property '" + propertyName + "'" + (StringUtils.hasLength(msg) ? ": " + msg : ""));
    }

    public UnsatisfiedDependencyException(String resourceDescription, String beanName, String propertyName, BeansException ex) {
        this(resourceDescription, beanName, propertyName, "");
        this.initCause(ex);
    }

    public UnsatisfiedDependencyException(String resourceDescription, String beanName, InjectionPoint injectionPoint, String msg) {
        super(resourceDescription, beanName, "Unsatisfied dependency expressed through " + injectionPoint + (StringUtils.hasLength(msg) ? ": " + msg : ""));
        this.injectionPoint = injectionPoint;
    }

    public UnsatisfiedDependencyException(String resourceDescription, String beanName, InjectionPoint injectionPoint, BeansException ex) {
        this(resourceDescription, beanName, injectionPoint, "");
        this.initCause(ex);
    }

    @Deprecated
    public UnsatisfiedDependencyException(String resourceDescription, String beanName, int ctorArgIndex, Class<?> ctorArgType, String msg) {
        super(resourceDescription, beanName, "Unsatisfied dependency expressed through constructor argument with index " + ctorArgIndex + " of type [" + ClassUtils.getQualifiedName(ctorArgType) + "]" + (msg != null ? ": " + msg : ""));
    }

    @Deprecated
    public UnsatisfiedDependencyException(String resourceDescription, String beanName, int ctorArgIndex, Class<?> ctorArgType, BeansException ex) {
        this(resourceDescription, beanName, ctorArgIndex, ctorArgType, ex != null ? ex.getMessage() : "");
        this.initCause(ex);
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }
}

