/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.factory.annotation;

import com.att.aft.dme2.internal.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import com.att.aft.dme2.internal.springframework.beans.factory.support.GenericBeanDefinition;
import com.att.aft.dme2.internal.springframework.core.type.AnnotationMetadata;
import com.att.aft.dme2.internal.springframework.core.type.MethodMetadata;
import com.att.aft.dme2.internal.springframework.core.type.StandardAnnotationMetadata;
import com.att.aft.dme2.internal.springframework.util.Assert;

public class AnnotatedGenericBeanDefinition
extends GenericBeanDefinition
implements AnnotatedBeanDefinition {
    private final AnnotationMetadata metadata;
    private MethodMetadata factoryMethodMetadata;

    public AnnotatedGenericBeanDefinition(Class<?> beanClass) {
        this.setBeanClass(beanClass);
        this.metadata = new StandardAnnotationMetadata(beanClass, true);
    }

    public AnnotatedGenericBeanDefinition(AnnotationMetadata metadata) {
        Assert.notNull(metadata, "AnnotationMetadata must not be null");
        if (metadata instanceof StandardAnnotationMetadata) {
            this.setBeanClass(((StandardAnnotationMetadata)metadata).getIntrospectedClass());
        } else {
            this.setBeanClassName(metadata.getClassName());
        }
        this.metadata = metadata;
    }

    public AnnotatedGenericBeanDefinition(AnnotationMetadata metadata, MethodMetadata factoryMethodMetadata) {
        this(metadata);
        Assert.notNull(factoryMethodMetadata, "MethodMetadata must not be null");
        this.setFactoryMethodName(factoryMethodMetadata.getMethodName());
        this.factoryMethodMetadata = factoryMethodMetadata;
    }

    @Override
    public final AnnotationMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public final MethodMetadata getFactoryMethodMetadata() {
        return this.factoryMethodMetadata;
    }
}

