/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.factory.annotation;

import com.att.aft.dme2.internal.springframework.beans.BeansException;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactoryUtils;
import com.att.aft.dme2.internal.springframework.beans.factory.ListableBeanFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.NoSuchBeanDefinitionException;
import com.att.aft.dme2.internal.springframework.beans.factory.NoUniqueBeanDefinitionException;
import com.att.aft.dme2.internal.springframework.beans.factory.annotation.Qualifier;
import com.att.aft.dme2.internal.springframework.beans.factory.config.BeanDefinition;
import com.att.aft.dme2.internal.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.support.AbstractBeanDefinition;
import com.att.aft.dme2.internal.springframework.beans.factory.support.AutowireCandidateQualifier;
import com.att.aft.dme2.internal.springframework.beans.factory.support.RootBeanDefinition;
import com.att.aft.dme2.internal.springframework.core.annotation.AnnotationUtils;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.util.ObjectUtils;
import java.lang.reflect.Method;

public abstract class BeanFactoryAnnotationUtils {
    public static <T> T qualifiedBeanOfType(BeanFactory beanFactory, Class<T> beanType, String qualifier) throws BeansException {
        Assert.notNull(beanFactory, "BeanFactory must not be null");
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            return BeanFactoryAnnotationUtils.qualifiedBeanOfType((ConfigurableListableBeanFactory)beanFactory, beanType, qualifier);
        }
        if (beanFactory.containsBean(qualifier)) {
            return beanFactory.getBean(qualifier, beanType);
        }
        throw new NoSuchBeanDefinitionException(qualifier, "No matching " + beanType.getSimpleName() + " bean found for bean name '" + qualifier + "'! (Note: Qualifier matching not supported because given BeanFactory does not implement ConfigurableListableBeanFactory.)");
    }

    private static <T> T qualifiedBeanOfType(ConfigurableListableBeanFactory bf, Class<T> beanType, String qualifier) {
        String[] candidateBeans = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)bf, beanType);
        String matchingBean = null;
        for (String beanName : candidateBeans) {
            if (!BeanFactoryAnnotationUtils.isQualifierMatch(qualifier, beanName, bf)) continue;
            if (matchingBean != null) {
                throw new NoUniqueBeanDefinitionException(beanType, new String[]{matchingBean, beanName});
            }
            matchingBean = beanName;
        }
        if (matchingBean != null) {
            return bf.getBean(matchingBean, beanType);
        }
        if (bf.containsBean(qualifier)) {
            return bf.getBean(qualifier, beanType);
        }
        throw new NoSuchBeanDefinitionException(qualifier, "No matching " + beanType.getSimpleName() + " bean found for qualifier '" + qualifier + "' - neither qualifier match nor bean name match!");
    }

    private static boolean isQualifierMatch(String qualifier, String beanName, ConfigurableListableBeanFactory bf) {
        if (bf.containsBean(beanName)) {
            try {
                Qualifier targetAnnotation;
                Method factoryMethod;
                AbstractBeanDefinition abd;
                AutowireCandidateQualifier candidate;
                BeanDefinition bd = bf.getMergedBeanDefinition(beanName);
                if (bd instanceof AbstractBeanDefinition && ((candidate = (abd = (AbstractBeanDefinition)bd).getQualifier(Qualifier.class.getName())) != null && qualifier.equals(candidate.getAttribute(AutowireCandidateQualifier.VALUE_KEY)) || qualifier.equals(beanName) || ObjectUtils.containsElement(bf.getAliases(beanName), qualifier))) {
                    return true;
                }
                if (bd instanceof RootBeanDefinition && (factoryMethod = ((RootBeanDefinition)bd).getResolvedFactoryMethod()) != null && (targetAnnotation = AnnotationUtils.getAnnotation(factoryMethod, Qualifier.class)) != null) {
                    return qualifier.equals(targetAnnotation.value());
                }
                Class<?> beanType = bf.getType(beanName);
                if (beanType != null && (targetAnnotation = AnnotationUtils.getAnnotation(beanType, Qualifier.class)) != null) {
                    return qualifier.equals(targetAnnotation.value());
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return false;
    }
}

