/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.factory.config;

import com.att.aft.dme2.internal.springframework.beans.factory.config.BeanExpressionContext;
import com.att.aft.dme2.internal.springframework.beans.factory.config.BeanExpressionResolver;
import com.att.aft.dme2.internal.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.att.aft.dme2.internal.springframework.util.StringValueResolver;

public class EmbeddedValueResolver
implements StringValueResolver {
    private final BeanExpressionContext exprContext;
    private final BeanExpressionResolver exprResolver;

    public EmbeddedValueResolver(ConfigurableBeanFactory beanFactory) {
        this.exprContext = new BeanExpressionContext(beanFactory, null);
        this.exprResolver = beanFactory.getBeanExpressionResolver();
    }

    @Override
    public String resolveStringValue(String strVal) {
        String value = this.exprContext.getBeanFactory().resolveEmbeddedValue(strVal);
        if (this.exprResolver != null && value != null) {
            Object evaluated = this.exprResolver.evaluate(value, this.exprContext);
            value = evaluated != null ? evaluated.toString() : null;
        }
        return value;
    }
}

