/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.factory.config;

import com.att.aft.dme2.internal.springframework.beans.BeanUtils;
import com.att.aft.dme2.internal.springframework.beans.TypeConverter;
import com.att.aft.dme2.internal.springframework.beans.factory.config.AbstractFactoryBean;
import com.att.aft.dme2.internal.springframework.core.GenericCollectionTypeResolver;
import java.util.ArrayList;
import java.util.List;

public class ListFactoryBean
extends AbstractFactoryBean<List<Object>> {
    private List<?> sourceList;
    private Class<? extends List> targetListClass;

    public void setSourceList(List<?> sourceList) {
        this.sourceList = sourceList;
    }

    public void setTargetListClass(Class<? extends List> targetListClass) {
        if (targetListClass == null) {
            throw new IllegalArgumentException("'targetListClass' must not be null");
        }
        if (!List.class.isAssignableFrom(targetListClass)) {
            throw new IllegalArgumentException("'targetListClass' must implement [java.util.List]");
        }
        this.targetListClass = targetListClass;
    }

    @Override
    public Class<List> getObjectType() {
        return List.class;
    }

    @Override
    protected List<Object> createInstance() {
        if (this.sourceList == null) {
            throw new IllegalArgumentException("'sourceList' is required");
        }
        ArrayList<Object> result = null;
        result = this.targetListClass != null ? BeanUtils.instantiateClass(this.targetListClass) : new ArrayList<Object>(this.sourceList.size());
        Class<?> valueType = null;
        if (this.targetListClass != null) {
            valueType = GenericCollectionTypeResolver.getCollectionType(this.targetListClass);
        }
        if (valueType != null) {
            TypeConverter converter = this.getBeanTypeConverter();
            for (Object elem : this.sourceList) {
                result.add(converter.convertIfNecessary(elem, valueType));
            }
        } else {
            result.addAll(this.sourceList);
        }
        return result;
    }
}

