/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.factory.config;

import com.att.aft.dme2.internal.springframework.beans.TypeConverter;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanClassLoaderAware;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactoryAware;
import com.att.aft.dme2.internal.springframework.beans.factory.InitializingBean;
import com.att.aft.dme2.internal.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.att.aft.dme2.internal.springframework.beans.support.ArgumentConvertingMethodInvoker;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import java.lang.reflect.InvocationTargetException;

public class MethodInvokingBean
extends ArgumentConvertingMethodInvoker
implements BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean {
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private ConfigurableBeanFactory beanFactory;

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    protected Class<?> resolveClassName(String className) throws ClassNotFoundException {
        return ClassUtils.forName(className, this.beanClassLoader);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        }
    }

    @Override
    protected TypeConverter getDefaultTypeConverter() {
        if (this.beanFactory != null) {
            return this.beanFactory.getTypeConverter();
        }
        return super.getDefaultTypeConverter();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.prepare();
        this.invokeWithTargetException();
    }

    protected Object invokeWithTargetException() throws Exception {
        try {
            return this.invoke();
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof Exception) {
                throw (Exception)ex.getTargetException();
            }
            if (ex.getTargetException() instanceof Error) {
                throw (Error)ex.getTargetException();
            }
            throw ex;
        }
    }
}

