/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.factory.config;

import com.att.aft.dme2.internal.springframework.beans.BeansException;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.ObjectFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.config.AbstractFactoryBean;
import com.att.aft.dme2.internal.springframework.util.Assert;
import java.io.Serializable;

public class ObjectFactoryCreatingFactoryBean
extends AbstractFactoryBean<ObjectFactory<Object>> {
    private String targetBeanName;

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.hasText(this.targetBeanName, "Property 'targetBeanName' is required");
        super.afterPropertiesSet();
    }

    @Override
    public Class<?> getObjectType() {
        return ObjectFactory.class;
    }

    @Override
    protected ObjectFactory<Object> createInstance() {
        return new TargetBeanObjectFactory(this.getBeanFactory(), this.targetBeanName);
    }

    private static class TargetBeanObjectFactory
    implements ObjectFactory<Object>,
    Serializable {
        private final BeanFactory beanFactory;
        private final String targetBeanName;

        public TargetBeanObjectFactory(BeanFactory beanFactory, String targetBeanName) {
            this.beanFactory = beanFactory;
            this.targetBeanName = targetBeanName;
        }

        @Override
        public Object getObject() throws BeansException {
            return this.beanFactory.getBean(this.targetBeanName);
        }
    }
}

