/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.factory.config;

import com.att.aft.dme2.internal.springframework.beans.BeansException;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanInitializationException;
import com.att.aft.dme2.internal.springframework.beans.factory.config.BeanFactoryPostProcessor;
import com.att.aft.dme2.internal.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.att.aft.dme2.internal.springframework.core.PriorityOrdered;
import com.att.aft.dme2.internal.springframework.core.io.support.PropertiesLoaderSupport;
import com.att.aft.dme2.internal.springframework.util.ObjectUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public abstract class PropertyResourceConfigurer
extends PropertiesLoaderSupport
implements BeanFactoryPostProcessor,
PriorityOrdered {
    private int order = Integer.MAX_VALUE;

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            Properties mergedProps = this.mergeProperties();
            this.convertProperties(mergedProps);
            this.processProperties(beanFactory, mergedProps);
        }
        catch (IOException ex) {
            throw new BeanInitializationException("Could not load properties", ex);
        }
    }

    protected void convertProperties(Properties props) {
        Enumeration<?> propertyNames = props.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String convertedValue;
            String propertyName = (String)propertyNames.nextElement();
            String propertyValue = props.getProperty(propertyName);
            if (ObjectUtils.nullSafeEquals(propertyValue, convertedValue = this.convertProperty(propertyName, propertyValue))) continue;
            props.setProperty(propertyName, convertedValue);
        }
    }

    protected String convertProperty(String propertyName, String propertyValue) {
        return this.convertPropertyValue(propertyValue);
    }

    protected String convertPropertyValue(String originalValue) {
        return originalValue;
    }

    protected abstract void processProperties(ConfigurableListableBeanFactory var1, Properties var2) throws BeansException;
}

