/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.factory.parsing;

import com.att.aft.dme2.internal.springframework.beans.factory.parsing.AbstractComponentDefinition;
import com.att.aft.dme2.internal.springframework.beans.factory.parsing.ComponentDefinition;
import com.att.aft.dme2.internal.springframework.util.Assert;
import java.util.LinkedList;
import java.util.List;

public class CompositeComponentDefinition
extends AbstractComponentDefinition {
    private final String name;
    private final Object source;
    private final List<ComponentDefinition> nestedComponents = new LinkedList<ComponentDefinition>();

    public CompositeComponentDefinition(String name, Object source) {
        Assert.notNull(name, "Name must not be null");
        this.name = name;
        this.source = source;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public void addNestedComponent(ComponentDefinition component) {
        Assert.notNull(component, "ComponentDefinition must not be null");
        this.nestedComponents.add(component);
    }

    public ComponentDefinition[] getNestedComponents() {
        return this.nestedComponents.toArray(new ComponentDefinition[this.nestedComponents.size()]);
    }
}

