/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.factory.xml;

import com.att.aft.dme2.internal.apache.commons.logging.Log;
import com.att.aft.dme2.internal.apache.commons.logging.LogFactory;
import com.att.aft.dme2.internal.springframework.core.io.ClassPathResource;
import java.io.IOException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BeansDtdResolver
implements EntityResolver {
    private static final String DTD_EXTENSION = ".dtd";
    private static final String DTD_FILENAME = "spring-beans-2.0";
    private static final String DTD_NAME = "spring-beans";
    private static final Log logger = LogFactory.getLog(BeansDtdResolver.class);

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        block6: {
            int lastPathSeparator;
            int dtdNameStart;
            if (logger.isTraceEnabled()) {
                logger.trace("Trying to resolve XML entity with public ID [" + publicId + "] and system ID [" + systemId + "]");
            }
            if (systemId != null && systemId.endsWith(DTD_EXTENSION) && (dtdNameStart = systemId.indexOf(DTD_NAME, lastPathSeparator = systemId.lastIndexOf("/"))) != -1) {
                String dtdFile = "spring-beans-2.0.dtd";
                if (logger.isTraceEnabled()) {
                    logger.trace("Trying to locate [" + dtdFile + "] in Spring jar on classpath");
                }
                try {
                    ClassPathResource resource = new ClassPathResource(dtdFile, this.getClass());
                    InputSource source = new InputSource(resource.getInputStream());
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found beans DTD [" + systemId + "] in classpath: " + dtdFile);
                    }
                    return source;
                }
                catch (IOException ex) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug("Could not resolve beans DTD [" + systemId + "]: not found in classpath", ex);
                }
            }
        }
        return null;
    }

    public String toString() {
        return "EntityResolver for spring-beans DTD";
    }
}

