/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.propertyeditors;

import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import com.att.aft.dme2.internal.springframework.util.StringUtils;
import java.beans.PropertyEditorSupport;

public class ClassEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;

    public ClassEditor() {
        this(null);
    }

    public ClassEditor(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText(text)) {
            this.setValue(ClassUtils.resolveClassName(text.trim(), this.classLoader));
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String getAsText() {
        Class clazz = (Class)this.getValue();
        if (clazz != null) {
            return ClassUtils.getQualifiedName(clazz);
        }
        return "";
    }
}

