/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.propertyeditors;

import com.att.aft.dme2.internal.springframework.core.io.Resource;
import com.att.aft.dme2.internal.springframework.core.io.ResourceEditor;
import com.att.aft.dme2.internal.springframework.util.Assert;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.net.URL;

public class URLEditor
extends PropertyEditorSupport {
    private final ResourceEditor resourceEditor;

    public URLEditor() {
        this.resourceEditor = new ResourceEditor();
    }

    public URLEditor(ResourceEditor resourceEditor) {
        Assert.notNull(resourceEditor, "ResourceEditor must not be null");
        this.resourceEditor = resourceEditor;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.resourceEditor.setAsText(text);
        Resource resource = (Resource)this.resourceEditor.getValue();
        try {
            this.setValue(resource != null ? resource.getURL() : null);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not retrieve URL for " + resource + ": " + ex.getMessage());
        }
    }

    @Override
    public String getAsText() {
        URL value = (URL)this.getValue();
        return value != null ? value.toExternalForm() : "";
    }
}

