/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.beans.support;

import com.att.aft.dme2.internal.springframework.beans.PropertyEditorRegistrar;
import com.att.aft.dme2.internal.springframework.beans.PropertyEditorRegistry;
import com.att.aft.dme2.internal.springframework.beans.PropertyEditorRegistrySupport;
import com.att.aft.dme2.internal.springframework.beans.propertyeditors.ClassArrayEditor;
import com.att.aft.dme2.internal.springframework.beans.propertyeditors.ClassEditor;
import com.att.aft.dme2.internal.springframework.beans.propertyeditors.FileEditor;
import com.att.aft.dme2.internal.springframework.beans.propertyeditors.InputSourceEditor;
import com.att.aft.dme2.internal.springframework.beans.propertyeditors.InputStreamEditor;
import com.att.aft.dme2.internal.springframework.beans.propertyeditors.PathEditor;
import com.att.aft.dme2.internal.springframework.beans.propertyeditors.ReaderEditor;
import com.att.aft.dme2.internal.springframework.beans.propertyeditors.URIEditor;
import com.att.aft.dme2.internal.springframework.beans.propertyeditors.URLEditor;
import com.att.aft.dme2.internal.springframework.core.env.PropertyResolver;
import com.att.aft.dme2.internal.springframework.core.io.ContextResource;
import com.att.aft.dme2.internal.springframework.core.io.Resource;
import com.att.aft.dme2.internal.springframework.core.io.ResourceEditor;
import com.att.aft.dme2.internal.springframework.core.io.ResourceLoader;
import com.att.aft.dme2.internal.springframework.core.io.support.ResourceArrayPropertyEditor;
import com.att.aft.dme2.internal.springframework.core.io.support.ResourcePatternResolver;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import org.xml.sax.InputSource;

public class ResourceEditorRegistrar
implements PropertyEditorRegistrar {
    private static Class<?> pathClass;
    private final PropertyResolver propertyResolver;
    private final ResourceLoader resourceLoader;

    public ResourceEditorRegistrar(ResourceLoader resourceLoader, PropertyResolver propertyResolver) {
        this.resourceLoader = resourceLoader;
        this.propertyResolver = propertyResolver;
    }

    @Override
    public void registerCustomEditors(PropertyEditorRegistry registry) {
        ResourceEditor baseEditor = new ResourceEditor(this.resourceLoader, this.propertyResolver);
        this.doRegisterEditor(registry, Resource.class, baseEditor);
        this.doRegisterEditor(registry, ContextResource.class, baseEditor);
        this.doRegisterEditor(registry, InputStream.class, new InputStreamEditor(baseEditor));
        this.doRegisterEditor(registry, InputSource.class, new InputSourceEditor(baseEditor));
        this.doRegisterEditor(registry, File.class, new FileEditor(baseEditor));
        if (pathClass != null) {
            this.doRegisterEditor(registry, pathClass, new PathEditor(baseEditor));
        }
        this.doRegisterEditor(registry, Reader.class, new ReaderEditor(baseEditor));
        this.doRegisterEditor(registry, URL.class, new URLEditor(baseEditor));
        ClassLoader classLoader = this.resourceLoader.getClassLoader();
        this.doRegisterEditor(registry, URI.class, new URIEditor(classLoader));
        this.doRegisterEditor(registry, Class.class, new ClassEditor(classLoader));
        this.doRegisterEditor(registry, Class[].class, new ClassArrayEditor(classLoader));
        if (this.resourceLoader instanceof ResourcePatternResolver) {
            this.doRegisterEditor(registry, Resource[].class, new ResourceArrayPropertyEditor((ResourcePatternResolver)this.resourceLoader, this.propertyResolver));
        }
    }

    private void doRegisterEditor(PropertyEditorRegistry registry, Class<?> requiredType, PropertyEditor editor) {
        if (registry instanceof PropertyEditorRegistrySupport) {
            ((PropertyEditorRegistrySupport)registry).overrideDefaultEditor(requiredType, editor);
        } else {
            registry.registerCustomEditor(requiredType, editor);
        }
    }

    static {
        try {
            pathClass = ClassUtils.forName("java.nio.file.Path", ResourceEditorRegistrar.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            pathClass = null;
        }
    }
}

