/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.cache.annotation;

import com.att.aft.dme2.internal.springframework.beans.factory.annotation.Autowired;
import com.att.aft.dme2.internal.springframework.cache.CacheManager;
import com.att.aft.dme2.internal.springframework.cache.annotation.CachingConfigurer;
import com.att.aft.dme2.internal.springframework.cache.annotation.EnableCaching;
import com.att.aft.dme2.internal.springframework.cache.interceptor.CacheErrorHandler;
import com.att.aft.dme2.internal.springframework.cache.interceptor.CacheResolver;
import com.att.aft.dme2.internal.springframework.cache.interceptor.KeyGenerator;
import com.att.aft.dme2.internal.springframework.context.annotation.Configuration;
import com.att.aft.dme2.internal.springframework.context.annotation.ImportAware;
import com.att.aft.dme2.internal.springframework.core.annotation.AnnotationAttributes;
import com.att.aft.dme2.internal.springframework.core.type.AnnotationMetadata;
import com.att.aft.dme2.internal.springframework.util.CollectionUtils;
import java.util.Collection;

@Configuration
public abstract class AbstractCachingConfiguration
implements ImportAware {
    protected AnnotationAttributes enableCaching;
    protected CacheManager cacheManager;
    protected CacheResolver cacheResolver;
    protected KeyGenerator keyGenerator;
    protected CacheErrorHandler errorHandler;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableCaching = AnnotationAttributes.fromMap(importMetadata.getAnnotationAttributes(EnableCaching.class.getName(), false));
        if (this.enableCaching == null) {
            throw new IllegalArgumentException("@EnableCaching is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    void setConfigurers(Collection<CachingConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException(configurers.size() + " implementations of CachingConfigurer were found when only 1 was expected. Refactor the configuration such that CachingConfigurer is implemented only once or not at all.");
        }
        CachingConfigurer configurer = configurers.iterator().next();
        this.useCachingConfigurer(configurer);
    }

    protected void useCachingConfigurer(CachingConfigurer config) {
        this.cacheManager = config.cacheManager();
        this.cacheResolver = config.cacheResolver();
        this.keyGenerator = config.keyGenerator();
        this.errorHandler = config.errorHandler();
    }
}

