/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.cache.annotation;

import com.att.aft.dme2.internal.springframework.cache.annotation.EnableCaching;
import com.att.aft.dme2.internal.springframework.cache.annotation.ProxyCachingConfiguration;
import com.att.aft.dme2.internal.springframework.context.annotation.AdviceMode;
import com.att.aft.dme2.internal.springframework.context.annotation.AdviceModeImportSelector;
import com.att.aft.dme2.internal.springframework.context.annotation.AutoProxyRegistrar;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import java.util.ArrayList;

public class CachingConfigurationSelector
extends AdviceModeImportSelector<EnableCaching> {
    private static final String PROXY_JCACHE_CONFIGURATION_CLASS = "com.att.aft.dme2.internal.springframework.cache.jcache.config.ProxyJCacheConfiguration";
    private static final String CACHE_ASPECT_CONFIGURATION_CLASS_NAME = "com.att.aft.dme2.internal.springframework.cache.aspectj.AspectJCachingConfiguration";
    private static final String JCACHE_ASPECT_CONFIGURATION_CLASS_NAME = "com.att.aft.dme2.internal.springframework.cache.aspectj.AspectJJCacheConfiguration";
    private static final boolean jsr107Present = ClassUtils.isPresent("javax.cache.Cache", CachingConfigurationSelector.class.getClassLoader());
    private static final boolean jcacheImplPresent = ClassUtils.isPresent("com.att.aft.dme2.internal.springframework.cache.jcache.config.ProxyJCacheConfiguration", CachingConfigurationSelector.class.getClassLoader());

    @Override
    public String[] selectImports(AdviceMode adviceMode) {
        switch (adviceMode) {
            case PROXY: {
                return this.getProxyImports();
            }
            case ASPECTJ: {
                return this.getAspectJImports();
            }
        }
        return null;
    }

    private String[] getProxyImports() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(AutoProxyRegistrar.class.getName());
        result.add(ProxyCachingConfiguration.class.getName());
        if (jsr107Present && jcacheImplPresent) {
            result.add(PROXY_JCACHE_CONFIGURATION_CLASS);
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] getAspectJImports() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(CACHE_ASPECT_CONFIGURATION_CLASS_NAME);
        if (jsr107Present && jcacheImplPresent) {
            result.add(JCACHE_ASPECT_CONFIGURATION_CLASS_NAME);
        }
        return result.toArray(new String[result.size()]);
    }
}

