/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.cache.annotation;

import com.att.aft.dme2.internal.springframework.cache.annotation.AbstractCachingConfiguration;
import com.att.aft.dme2.internal.springframework.cache.annotation.AnnotationCacheOperationSource;
import com.att.aft.dme2.internal.springframework.cache.interceptor.BeanFactoryCacheOperationSourceAdvisor;
import com.att.aft.dme2.internal.springframework.cache.interceptor.CacheInterceptor;
import com.att.aft.dme2.internal.springframework.cache.interceptor.CacheOperationSource;
import com.att.aft.dme2.internal.springframework.context.annotation.Bean;
import com.att.aft.dme2.internal.springframework.context.annotation.Configuration;
import com.att.aft.dme2.internal.springframework.context.annotation.Role;

@Configuration
public class ProxyCachingConfiguration
extends AbstractCachingConfiguration {
    @Bean(name={"com.att.aft.dme2.internal.springframework.cache.config.internalCacheAdvisor"})
    @Role(value=2)
    public BeanFactoryCacheOperationSourceAdvisor cacheAdvisor() {
        BeanFactoryCacheOperationSourceAdvisor advisor = new BeanFactoryCacheOperationSourceAdvisor();
        advisor.setCacheOperationSource(this.cacheOperationSource());
        advisor.setAdvice(this.cacheInterceptor());
        advisor.setOrder((Integer)this.enableCaching.getNumber("order"));
        return advisor;
    }

    @Bean
    @Role(value=2)
    public CacheOperationSource cacheOperationSource() {
        return new AnnotationCacheOperationSource();
    }

    @Bean
    @Role(value=2)
    public CacheInterceptor cacheInterceptor() {
        CacheInterceptor interceptor = new CacheInterceptor();
        interceptor.setCacheOperationSources(this.cacheOperationSource());
        if (this.cacheResolver != null) {
            interceptor.setCacheResolver(this.cacheResolver);
        } else if (this.cacheManager != null) {
            interceptor.setCacheManager(this.cacheManager);
        }
        if (this.keyGenerator != null) {
            interceptor.setKeyGenerator(this.keyGenerator);
        }
        if (this.errorHandler != null) {
            interceptor.setErrorHandler(this.errorHandler);
        }
        return interceptor;
    }
}

