/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.cache.interceptor;

import com.att.aft.dme2.internal.springframework.beans.factory.InitializingBean;
import com.att.aft.dme2.internal.springframework.cache.Cache;
import com.att.aft.dme2.internal.springframework.cache.CacheManager;
import com.att.aft.dme2.internal.springframework.cache.interceptor.CacheOperationInvocationContext;
import com.att.aft.dme2.internal.springframework.cache.interceptor.CacheResolver;
import com.att.aft.dme2.internal.springframework.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractCacheResolver
implements CacheResolver,
InitializingBean {
    private CacheManager cacheManager;

    protected AbstractCacheResolver() {
    }

    protected AbstractCacheResolver(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull(this.cacheManager, "CacheManager must not be null");
    }

    @Override
    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        Collection<String> cacheNames = this.getCacheNames(context);
        if (cacheNames == null) {
            return Collections.emptyList();
        }
        ArrayList<Cache> result = new ArrayList<Cache>();
        for (String cacheName : cacheNames) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                throw new IllegalArgumentException("Cannot find cache named '" + cacheName + "' for " + context.getOperation());
            }
            result.add(cache);
        }
        return result;
    }

    protected abstract Collection<String> getCacheNames(CacheOperationInvocationContext<?> var1);
}

