/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.access;

import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.access.BeanFactoryReference;
import com.att.aft.dme2.internal.springframework.context.ApplicationContext;
import com.att.aft.dme2.internal.springframework.context.ConfigurableApplicationContext;

public class ContextBeanFactoryReference
implements BeanFactoryReference {
    private ApplicationContext applicationContext;

    public ContextBeanFactoryReference(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public BeanFactory getFactory() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("ApplicationContext owned by this BeanFactoryReference has been released");
        }
        return this.applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.applicationContext != null) {
            ApplicationContext savedCtx;
            ContextBeanFactoryReference contextBeanFactoryReference = this;
            synchronized (contextBeanFactoryReference) {
                savedCtx = this.applicationContext;
                this.applicationContext = null;
            }
            if (savedCtx != null && savedCtx instanceof ConfigurableApplicationContext) {
                ((ConfigurableApplicationContext)savedCtx).close();
            }
        }
    }
}

