/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.annotation;

import com.att.aft.dme2.internal.springframework.context.annotation.AdviceMode;
import com.att.aft.dme2.internal.springframework.context.annotation.AnnotationConfigUtils;
import com.att.aft.dme2.internal.springframework.context.annotation.ImportSelector;
import com.att.aft.dme2.internal.springframework.core.GenericTypeResolver;
import com.att.aft.dme2.internal.springframework.core.annotation.AnnotationAttributes;
import com.att.aft.dme2.internal.springframework.core.type.AnnotatedTypeMetadata;
import com.att.aft.dme2.internal.springframework.core.type.AnnotationMetadata;
import java.lang.annotation.Annotation;

public abstract class AdviceModeImportSelector<A extends Annotation>
implements ImportSelector {
    public static final String DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME = "mode";

    protected String getAdviceModeAttributeName() {
        return DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME;
    }

    @Override
    public final String[] selectImports(AnnotationMetadata importingClassMetadata) {
        Class<?> annoType = GenericTypeResolver.resolveTypeArgument(this.getClass(), AdviceModeImportSelector.class);
        AnnotationAttributes attributes = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)importingClassMetadata, annoType);
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("@%s is not present on importing class '%s' as expected", annoType.getSimpleName(), importingClassMetadata.getClassName()));
        }
        AdviceMode adviceMode = (AdviceMode)((Object)attributes.getEnum(this.getAdviceModeAttributeName()));
        String[] imports = this.selectImports(adviceMode);
        if (imports == null) {
            throw new IllegalArgumentException(String.format("Unknown AdviceMode: '%s'", new Object[]{adviceMode}));
        }
        return imports;
    }

    protected abstract String[] selectImports(AdviceMode var1);
}

