/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.annotation;

import com.att.aft.dme2.internal.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import com.att.aft.dme2.internal.springframework.beans.factory.config.BeanDefinitionHolder;
import com.att.aft.dme2.internal.springframework.beans.factory.support.AutowireCandidateQualifier;
import com.att.aft.dme2.internal.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import com.att.aft.dme2.internal.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.att.aft.dme2.internal.springframework.beans.factory.support.BeanNameGenerator;
import com.att.aft.dme2.internal.springframework.context.annotation.AnnotationBeanNameGenerator;
import com.att.aft.dme2.internal.springframework.context.annotation.AnnotationConfigUtils;
import com.att.aft.dme2.internal.springframework.context.annotation.AnnotationScopeMetadataResolver;
import com.att.aft.dme2.internal.springframework.context.annotation.ConditionEvaluator;
import com.att.aft.dme2.internal.springframework.context.annotation.Lazy;
import com.att.aft.dme2.internal.springframework.context.annotation.Primary;
import com.att.aft.dme2.internal.springframework.context.annotation.ScopeMetadata;
import com.att.aft.dme2.internal.springframework.context.annotation.ScopeMetadataResolver;
import com.att.aft.dme2.internal.springframework.core.env.Environment;
import com.att.aft.dme2.internal.springframework.core.env.EnvironmentCapable;
import com.att.aft.dme2.internal.springframework.core.env.StandardEnvironment;
import com.att.aft.dme2.internal.springframework.util.Assert;
import java.lang.annotation.Annotation;

public class AnnotatedBeanDefinitionReader {
    private final BeanDefinitionRegistry registry;
    private BeanNameGenerator beanNameGenerator = new AnnotationBeanNameGenerator();
    private ScopeMetadataResolver scopeMetadataResolver = new AnnotationScopeMetadataResolver();
    private ConditionEvaluator conditionEvaluator;

    public AnnotatedBeanDefinitionReader(BeanDefinitionRegistry registry) {
        this(registry, AnnotatedBeanDefinitionReader.getOrCreateEnvironment(registry));
    }

    public AnnotatedBeanDefinitionReader(BeanDefinitionRegistry registry, Environment environment) {
        Assert.notNull(registry, "BeanDefinitionRegistry must not be null");
        Assert.notNull(environment, "Environment must not be null");
        this.registry = registry;
        this.conditionEvaluator = new ConditionEvaluator(registry, environment, null);
        AnnotationConfigUtils.registerAnnotationConfigProcessors(this.registry);
    }

    public final BeanDefinitionRegistry getRegistry() {
        return this.registry;
    }

    public void setEnvironment(Environment environment) {
        this.conditionEvaluator = new ConditionEvaluator(this.registry, environment, null);
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator != null ? beanNameGenerator : new AnnotationBeanNameGenerator();
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.scopeMetadataResolver = scopeMetadataResolver != null ? scopeMetadataResolver : new AnnotationScopeMetadataResolver();
    }

    public void register(Class<?> ... annotatedClasses) {
        for (Class<?> annotatedClass : annotatedClasses) {
            this.registerBean(annotatedClass);
        }
    }

    public void registerBean(Class<?> annotatedClass) {
        this.registerBean(annotatedClass, (String)null, (Class<? extends Annotation>[])null);
    }

    public void registerBean(Class<?> annotatedClass, Class<? extends Annotation> ... qualifiers) {
        this.registerBean(annotatedClass, (String)null, qualifiers);
    }

    public void registerBean(Class<?> annotatedClass, String name, Class<? extends Annotation> ... qualifiers) {
        AnnotatedGenericBeanDefinition abd = new AnnotatedGenericBeanDefinition(annotatedClass);
        if (this.conditionEvaluator.shouldSkip(abd.getMetadata())) {
            return;
        }
        ScopeMetadata scopeMetadata = this.scopeMetadataResolver.resolveScopeMetadata(abd);
        abd.setScope(scopeMetadata.getScopeName());
        String beanName = name != null ? name : this.beanNameGenerator.generateBeanName(abd, this.registry);
        AnnotationConfigUtils.processCommonDefinitionAnnotations(abd);
        if (qualifiers != null) {
            for (Class<? extends Annotation> qualifier : qualifiers) {
                if (Primary.class == qualifier) {
                    abd.setPrimary(true);
                    continue;
                }
                if (Lazy.class == qualifier) {
                    abd.setLazyInit(true);
                    continue;
                }
                abd.addQualifier(new AutowireCandidateQualifier(qualifier));
            }
        }
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(abd, beanName);
        definitionHolder = AnnotationConfigUtils.applyScopedProxyMode(scopeMetadata, definitionHolder, this.registry);
        BeanDefinitionReaderUtils.registerBeanDefinition(definitionHolder, this.registry);
    }

    private static Environment getOrCreateEnvironment(BeanDefinitionRegistry registry) {
        Assert.notNull(registry, "BeanDefinitionRegistry must not be null");
        if (registry instanceof EnvironmentCapable) {
            return ((EnvironmentCapable)((Object)registry)).getEnvironment();
        }
        return new StandardEnvironment();
    }
}

