/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.annotation;

import com.att.aft.dme2.internal.springframework.beans.factory.support.BeanNameGenerator;
import com.att.aft.dme2.internal.springframework.beans.factory.support.DefaultListableBeanFactory;
import com.att.aft.dme2.internal.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import com.att.aft.dme2.internal.springframework.context.annotation.AnnotationConfigRegistry;
import com.att.aft.dme2.internal.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import com.att.aft.dme2.internal.springframework.context.annotation.ScopeMetadataResolver;
import com.att.aft.dme2.internal.springframework.context.support.GenericApplicationContext;
import com.att.aft.dme2.internal.springframework.core.env.ConfigurableEnvironment;
import com.att.aft.dme2.internal.springframework.util.Assert;

public class AnnotationConfigApplicationContext
extends GenericApplicationContext
implements AnnotationConfigRegistry {
    private final AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(this);
    private final ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(this);

    public AnnotationConfigApplicationContext() {
    }

    public AnnotationConfigApplicationContext(DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    public AnnotationConfigApplicationContext(Class<?> ... annotatedClasses) {
        this();
        this.register(annotatedClasses);
        this.refresh();
    }

    public AnnotationConfigApplicationContext(String ... basePackages) {
        this();
        this.scan(basePackages);
        this.refresh();
    }

    @Override
    public void setEnvironment(ConfigurableEnvironment environment) {
        super.setEnvironment(environment);
        this.reader.setEnvironment(environment);
        this.scanner.setEnvironment(environment);
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.reader.setBeanNameGenerator(beanNameGenerator);
        this.scanner.setBeanNameGenerator(beanNameGenerator);
        this.getBeanFactory().registerSingleton("com.att.aft.dme2.internal.springframework.context.annotation.internalConfigurationBeanNameGenerator", beanNameGenerator);
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.reader.setScopeMetadataResolver(scopeMetadataResolver);
        this.scanner.setScopeMetadataResolver(scopeMetadataResolver);
    }

    @Override
    public void register(Class<?> ... annotatedClasses) {
        Assert.notEmpty(annotatedClasses, "At least one annotated class must be specified");
        this.reader.register(annotatedClasses);
    }

    @Override
    public void scan(String ... basePackages) {
        Assert.notEmpty(basePackages, "At least one base package must be specified");
        this.scanner.scan(basePackages);
    }

    @Override
    protected void prepareRefresh() {
        this.scanner.clearCache();
        super.prepareRefresh();
    }
}

