/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.annotation;

import com.att.aft.dme2.internal.springframework.beans.factory.parsing.Problem;
import com.att.aft.dme2.internal.springframework.beans.factory.parsing.ProblemReporter;
import com.att.aft.dme2.internal.springframework.context.annotation.Configuration;
import com.att.aft.dme2.internal.springframework.context.annotation.ConfigurationClass;
import com.att.aft.dme2.internal.springframework.context.annotation.ConfigurationMethod;
import com.att.aft.dme2.internal.springframework.core.type.MethodMetadata;

final class BeanMethod
extends ConfigurationMethod {
    public BeanMethod(MethodMetadata metadata, ConfigurationClass configurationClass) {
        super(metadata, configurationClass);
    }

    @Override
    public void validate(ProblemReporter problemReporter) {
        if (this.getMetadata().isStatic()) {
            return;
        }
        if (this.configurationClass.getMetadata().isAnnotated(Configuration.class.getName()) && !this.getMetadata().isOverridable()) {
            problemReporter.error(new NonOverridableMethodError());
        }
    }

    private class NonOverridableMethodError
    extends Problem {
        public NonOverridableMethodError() {
            super(String.format("@Bean method '%s' must not be private or final; change the method's modifiers to continue", BeanMethod.this.getMetadata().getMethodName()), BeanMethod.this.getResourceLocation());
        }
    }
}

