/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.annotation;

import com.att.aft.dme2.internal.springframework.beans.BeanUtils;
import com.att.aft.dme2.internal.springframework.beans.factory.config.BeanDefinitionHolder;
import com.att.aft.dme2.internal.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.att.aft.dme2.internal.springframework.beans.factory.support.BeanNameGenerator;
import com.att.aft.dme2.internal.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import com.att.aft.dme2.internal.springframework.context.annotation.FilterType;
import com.att.aft.dme2.internal.springframework.context.annotation.ParserStrategyUtils;
import com.att.aft.dme2.internal.springframework.context.annotation.ScopeMetadataResolver;
import com.att.aft.dme2.internal.springframework.context.annotation.ScopedProxyMode;
import com.att.aft.dme2.internal.springframework.core.annotation.AnnotationAttributes;
import com.att.aft.dme2.internal.springframework.core.env.Environment;
import com.att.aft.dme2.internal.springframework.core.io.ResourceLoader;
import com.att.aft.dme2.internal.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import com.att.aft.dme2.internal.springframework.core.type.filter.AnnotationTypeFilter;
import com.att.aft.dme2.internal.springframework.core.type.filter.AspectJTypeFilter;
import com.att.aft.dme2.internal.springframework.core.type.filter.AssignableTypeFilter;
import com.att.aft.dme2.internal.springframework.core.type.filter.RegexPatternTypeFilter;
import com.att.aft.dme2.internal.springframework.core.type.filter.TypeFilter;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import com.att.aft.dme2.internal.springframework.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

class ComponentScanAnnotationParser {
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final BeanNameGenerator beanNameGenerator;
    private final BeanDefinitionRegistry registry;

    public ComponentScanAnnotationParser(Environment environment, ResourceLoader resourceLoader, BeanNameGenerator beanNameGenerator, BeanDefinitionRegistry registry) {
        this.resourceLoader = resourceLoader;
        this.environment = environment;
        this.beanNameGenerator = beanNameGenerator;
        this.registry = registry;
    }

    public Set<BeanDefinitionHolder> parse(AnnotationAttributes componentScan, final String declaringClass) {
        Assert.state(this.environment != null, "Environment must not be null");
        Assert.state(this.resourceLoader != null, "ResourceLoader must not be null");
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(this.registry, componentScan.getBoolean("useDefaultFilters"));
        scanner.setEnvironment(this.environment);
        scanner.setResourceLoader(this.resourceLoader);
        Class generatorClass = componentScan.getClass("nameGenerator");
        boolean useInheritedGenerator = BeanNameGenerator.class == generatorClass;
        scanner.setBeanNameGenerator(useInheritedGenerator ? this.beanNameGenerator : (BeanNameGenerator)BeanUtils.instantiateClass(generatorClass));
        ScopedProxyMode scopedProxyMode = (ScopedProxyMode)((Object)componentScan.getEnum("scopedProxy"));
        if (scopedProxyMode != ScopedProxyMode.DEFAULT) {
            scanner.setScopedProxyMode(scopedProxyMode);
        } else {
            AnnotationAttributes[] resolverClass = componentScan.getClass("scopeResolver");
            scanner.setScopeMetadataResolver((ScopeMetadataResolver)BeanUtils.instantiateClass(resolverClass));
        }
        scanner.setResourcePattern(componentScan.getString("resourcePattern"));
        for (AnnotationAttributes filter : componentScan.getAnnotationArray("includeFilters")) {
            for (TypeFilter typeFilter : this.typeFiltersFor(filter)) {
                scanner.addIncludeFilter(typeFilter);
            }
        }
        for (AnnotationAttributes filter : componentScan.getAnnotationArray("excludeFilters")) {
            for (TypeFilter typeFilter : this.typeFiltersFor(filter)) {
                scanner.addExcludeFilter(typeFilter);
            }
        }
        boolean lazyInit = componentScan.getBoolean("lazyInit");
        if (lazyInit) {
            scanner.getBeanDefinitionDefaults().setLazyInit(true);
        }
        LinkedHashSet<String> basePackages = new LinkedHashSet<String>();
        String[] basePackagesArray = componentScan.getStringArray("basePackages");
        for (String pkg : basePackagesArray) {
            String[] tokenized = StringUtils.tokenizeToStringArray(this.environment.resolvePlaceholders(pkg), ",; \t\n");
            basePackages.addAll(Arrays.asList(tokenized));
        }
        for (Class<?> clazz : componentScan.getClassArray("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName(clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName(declaringClass));
        }
        scanner.addExcludeFilter(new AbstractTypeHierarchyTraversingFilter(false, false){

            @Override
            protected boolean matchClassName(String className) {
                return declaringClass.equals(className);
            }
        });
        return scanner.doScan(StringUtils.toStringArray(basePackages));
    }

    private List<TypeFilter> typeFiltersFor(AnnotationAttributes filterAttributes) {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        FilterType filterType = (FilterType)((Object)filterAttributes.getEnum("type"));
        block9: for (Class<?> filterClass : filterAttributes.getClassArray("classes")) {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, filterClass, "An error occurred while processing a @ComponentScan ANNOTATION type filter: ");
                    Class<?> annotationType = filterClass;
                    typeFilters.add(new AnnotationTypeFilter(annotationType));
                    continue block9;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add(new AssignableTypeFilter(filterClass));
                    continue block9;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, filterClass, "An error occurred while processing a @ComponentScan CUSTOM type filter: ");
                    TypeFilter filter = BeanUtils.instantiateClass(filterClass, TypeFilter.class);
                    ParserStrategyUtils.invokeAwareMethods(filter, this.environment, this.resourceLoader, this.registry);
                    typeFilters.add(filter);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Filter type not supported with Class value: " + (Object)((Object)filterType));
                }
            }
        }
        block10: for (String expression : filterAttributes.getStringArray("pattern")) {
            switch (filterType) {
                case ASPECTJ: {
                    typeFilters.add(new AspectJTypeFilter(expression, this.resourceLoader.getClassLoader()));
                    continue block10;
                }
                case REGEX: {
                    typeFilters.add(new RegexPatternTypeFilter(Pattern.compile(expression)));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Filter type not supported with String pattern: " + (Object)((Object)filterType));
                }
            }
        }
        return typeFilters;
    }
}

