/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.annotation;

import com.att.aft.dme2.internal.springframework.beans.factory.BeanClassLoaderAware;
import com.att.aft.dme2.internal.springframework.beans.factory.annotation.Autowired;
import com.att.aft.dme2.internal.springframework.context.annotation.AnnotationConfigUtils;
import com.att.aft.dme2.internal.springframework.context.annotation.Bean;
import com.att.aft.dme2.internal.springframework.context.annotation.Configuration;
import com.att.aft.dme2.internal.springframework.context.annotation.EnableLoadTimeWeaving;
import com.att.aft.dme2.internal.springframework.context.annotation.ImportAware;
import com.att.aft.dme2.internal.springframework.context.annotation.LoadTimeWeavingConfigurer;
import com.att.aft.dme2.internal.springframework.context.annotation.Role;
import com.att.aft.dme2.internal.springframework.context.weaving.AspectJWeavingEnabler;
import com.att.aft.dme2.internal.springframework.context.weaving.DefaultContextLoadTimeWeaver;
import com.att.aft.dme2.internal.springframework.core.annotation.AnnotationAttributes;
import com.att.aft.dme2.internal.springframework.core.type.AnnotatedTypeMetadata;
import com.att.aft.dme2.internal.springframework.core.type.AnnotationMetadata;
import com.att.aft.dme2.internal.springframework.instrument.classloading.LoadTimeWeaver;

@Configuration
public class LoadTimeWeavingConfiguration
implements ImportAware,
BeanClassLoaderAware {
    private AnnotationAttributes enableLTW;
    private LoadTimeWeavingConfigurer ltwConfigurer;
    private ClassLoader beanClassLoader;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableLTW = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)importMetadata, EnableLoadTimeWeaving.class);
        if (this.enableLTW == null) {
            throw new IllegalArgumentException("@EnableLoadTimeWeaving is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    public void setLoadTimeWeavingConfigurer(LoadTimeWeavingConfigurer ltwConfigurer) {
        this.ltwConfigurer = ltwConfigurer;
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Bean(name={"loadTimeWeaver"})
    @Role(value=2)
    public LoadTimeWeaver loadTimeWeaver() {
        LoadTimeWeaver loadTimeWeaver = null;
        if (this.ltwConfigurer != null) {
            loadTimeWeaver = this.ltwConfigurer.getLoadTimeWeaver();
        }
        if (loadTimeWeaver == null) {
            loadTimeWeaver = new DefaultContextLoadTimeWeaver(this.beanClassLoader);
        }
        EnableLoadTimeWeaving.AspectJWeaving aspectJWeaving = (EnableLoadTimeWeaving.AspectJWeaving)((Object)this.enableLTW.getEnum("aspectjWeaving"));
        switch (aspectJWeaving) {
            case DISABLED: {
                break;
            }
            case AUTODETECT: {
                if (this.beanClassLoader.getResource("META-INF/aop.xml") == null) break;
                AspectJWeavingEnabler.enableAspectJWeaving(loadTimeWeaver, this.beanClassLoader);
                break;
            }
            case ENABLED: {
                AspectJWeavingEnabler.enableAspectJWeaving(loadTimeWeaver, this.beanClassLoader);
            }
        }
        return loadTimeWeaver;
    }
}

