/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.config;

import com.att.aft.dme2.internal.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import com.att.aft.dme2.internal.springframework.beans.factory.support.BeanDefinitionBuilder;
import com.att.aft.dme2.internal.springframework.context.config.AbstractPropertyLoadingBeanDefinitionParser;
import com.att.aft.dme2.internal.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import com.att.aft.dme2.internal.springframework.util.StringUtils;
import org.w3c.dom.Element;

class PropertyPlaceholderBeanDefinitionParser
extends AbstractPropertyLoadingBeanDefinitionParser {
    private static final String SYSTEM_PROPERTIES_MODE_ATTRIBUTE = "system-properties-mode";
    private static final String SYSTEM_PROPERTIES_MODE_DEFAULT = "ENVIRONMENT";

    PropertyPlaceholderBeanDefinitionParser() {
    }

    @Override
    protected Class<?> getBeanClass(Element element) {
        if (SYSTEM_PROPERTIES_MODE_DEFAULT.equals(element.getAttribute(SYSTEM_PROPERTIES_MODE_ATTRIBUTE))) {
            return PropertySourcesPlaceholderConfigurer.class;
        }
        return PropertyPlaceholderConfigurer.class;
    }

    @Override
    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        builder.addPropertyValue("ignoreUnresolvablePlaceholders", Boolean.valueOf(element.getAttribute("ignore-unresolvable")));
        String systemPropertiesModeName = element.getAttribute(SYSTEM_PROPERTIES_MODE_ATTRIBUTE);
        if (StringUtils.hasLength(systemPropertiesModeName) && !systemPropertiesModeName.equals(SYSTEM_PROPERTIES_MODE_DEFAULT)) {
            builder.addPropertyValue("systemPropertiesModeName", "SYSTEM_PROPERTIES_MODE_" + systemPropertiesModeName);
        }
        if (element.hasAttribute("value-separator")) {
            builder.addPropertyValue("valueSeparator", element.getAttribute("value-separator"));
        }
        if (element.hasAttribute("trim-values")) {
            builder.addPropertyValue("trimValues", element.getAttribute("trim-values"));
        }
        if (element.hasAttribute("null-value")) {
            builder.addPropertyValue("nullValue", element.getAttribute("null-value"));
        }
    }
}

