/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.event;

import com.att.aft.dme2.internal.springframework.aop.support.AopUtils;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.context.ApplicationEvent;
import com.att.aft.dme2.internal.springframework.context.event.EventExpressionRootObject;
import com.att.aft.dme2.internal.springframework.context.expression.AnnotatedElementKey;
import com.att.aft.dme2.internal.springframework.context.expression.BeanFactoryResolver;
import com.att.aft.dme2.internal.springframework.context.expression.CachedExpressionEvaluator;
import com.att.aft.dme2.internal.springframework.context.expression.MethodBasedEvaluationContext;
import com.att.aft.dme2.internal.springframework.expression.EvaluationContext;
import com.att.aft.dme2.internal.springframework.expression.Expression;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class EventExpressionEvaluator
extends CachedExpressionEvaluator {
    private final Map<CachedExpressionEvaluator.ExpressionKey, Expression> conditionCache = new ConcurrentHashMap<CachedExpressionEvaluator.ExpressionKey, Expression>(64);
    private final Map<AnnotatedElementKey, Method> targetMethodCache = new ConcurrentHashMap<AnnotatedElementKey, Method>(64);

    EventExpressionEvaluator() {
    }

    public EvaluationContext createEvaluationContext(ApplicationEvent event, Class<?> targetClass, Method method, Object[] args, BeanFactory beanFactory) {
        Method targetMethod = this.getTargetMethod(targetClass, method);
        EventExpressionRootObject root = new EventExpressionRootObject(event, args);
        MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext(root, targetMethod, args, this.getParameterNameDiscoverer());
        if (beanFactory != null) {
            evaluationContext.setBeanResolver(new BeanFactoryResolver(beanFactory));
        }
        return evaluationContext;
    }

    public boolean condition(String conditionExpression, AnnotatedElementKey elementKey, EvaluationContext evalContext) {
        return this.getExpression(this.conditionCache, elementKey, conditionExpression).getValue(evalContext, Boolean.TYPE);
    }

    private Method getTargetMethod(Class<?> targetClass, Method method) {
        AnnotatedElementKey methodKey = new AnnotatedElementKey(method, targetClass);
        Method targetMethod = this.targetMethodCache.get(methodKey);
        if (targetMethod == null) {
            targetMethod = AopUtils.getMostSpecificMethod(method, targetClass);
            if (targetMethod == null) {
                targetMethod = method;
            }
            this.targetMethodCache.put(methodKey, targetMethod);
        }
        return targetMethod;
    }
}

