/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.event;

import com.att.aft.dme2.internal.springframework.aop.support.AopUtils;
import com.att.aft.dme2.internal.springframework.context.ApplicationEvent;
import com.att.aft.dme2.internal.springframework.context.ApplicationListener;
import com.att.aft.dme2.internal.springframework.context.event.GenericApplicationListener;
import com.att.aft.dme2.internal.springframework.context.event.SmartApplicationListener;
import com.att.aft.dme2.internal.springframework.core.Ordered;
import com.att.aft.dme2.internal.springframework.core.ResolvableType;
import com.att.aft.dme2.internal.springframework.util.Assert;

public class GenericApplicationListenerAdapter
implements GenericApplicationListener,
SmartApplicationListener {
    private final ApplicationListener<ApplicationEvent> delegate;
    private final ResolvableType declaredEventType;

    public GenericApplicationListenerAdapter(ApplicationListener<?> delegate) {
        Assert.notNull(delegate, "Delegate listener must not be null");
        this.delegate = delegate;
        this.declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(this.delegate);
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        this.delegate.onApplicationEvent(event);
    }

    @Override
    public boolean supportsEventType(ResolvableType eventType) {
        if (this.delegate instanceof SmartApplicationListener) {
            Class<?> eventClass = eventType.getRawClass();
            return ((SmartApplicationListener)this.delegate).supportsEventType(eventClass);
        }
        return this.declaredEventType == null || this.declaredEventType.isAssignableFrom(eventType);
    }

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return this.supportsEventType(ResolvableType.forType(eventType));
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        if (this.delegate instanceof SmartApplicationListener) {
            return ((SmartApplicationListener)this.delegate).supportsSourceType(sourceType);
        }
        return true;
    }

    @Override
    public int getOrder() {
        return this.delegate instanceof Ordered ? ((Ordered)((Object)this.delegate)).getOrder() : Integer.MAX_VALUE;
    }

    static ResolvableType resolveDeclaredEventType(Class<?> listenerType) {
        ResolvableType resolvableType = ResolvableType.forClass(listenerType).as(ApplicationListener.class);
        if (resolvableType == null || !resolvableType.hasGenerics()) {
            return null;
        }
        return resolvableType.getGeneric(new int[0]);
    }

    private static ResolvableType resolveDeclaredEventType(ApplicationListener<ApplicationEvent> listener) {
        Class<?> targetClass;
        ResolvableType declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(listener.getClass());
        if ((declaredEventType == null || declaredEventType.isAssignableFrom(ResolvableType.forClass(ApplicationEvent.class))) && (targetClass = AopUtils.getTargetClass(listener)) != listener.getClass()) {
            declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(targetClass);
        }
        return declaredEventType;
    }
}

