/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.expression;

import com.att.aft.dme2.internal.springframework.beans.BeansException;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.expression.AccessException;
import com.att.aft.dme2.internal.springframework.expression.BeanResolver;
import com.att.aft.dme2.internal.springframework.expression.EvaluationContext;
import com.att.aft.dme2.internal.springframework.util.Assert;

public class BeanFactoryResolver
implements BeanResolver {
    private final BeanFactory beanFactory;

    public BeanFactoryResolver(BeanFactory beanFactory) {
        Assert.notNull(beanFactory, "BeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    @Override
    public Object resolve(EvaluationContext context, String beanName) throws AccessException {
        try {
            return this.beanFactory.getBean(beanName);
        }
        catch (BeansException ex) {
            throw new AccessException("Could not resolve bean reference against BeanFactory", ex);
        }
    }
}

