/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.support;

import com.att.aft.dme2.internal.springframework.context.MessageSource;
import com.att.aft.dme2.internal.springframework.context.MessageSourceResolvable;
import com.att.aft.dme2.internal.springframework.context.NoSuchMessageException;
import com.att.aft.dme2.internal.springframework.context.i18n.LocaleContextHolder;
import java.util.Locale;

public class MessageSourceAccessor {
    private final MessageSource messageSource;
    private final Locale defaultLocale;

    public MessageSourceAccessor(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.defaultLocale = null;
    }

    public MessageSourceAccessor(MessageSource messageSource, Locale defaultLocale) {
        this.messageSource = messageSource;
        this.defaultLocale = defaultLocale;
    }

    protected Locale getDefaultLocale() {
        return this.defaultLocale != null ? this.defaultLocale : LocaleContextHolder.getLocale();
    }

    public String getMessage(String code, String defaultMessage) {
        return this.messageSource.getMessage(code, null, defaultMessage, this.getDefaultLocale());
    }

    public String getMessage(String code, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(code, null, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, String defaultMessage) {
        return this.messageSource.getMessage(code, args, defaultMessage, this.getDefaultLocale());
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, null, this.getDefaultLocale());
    }

    public String getMessage(String code, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, null, locale);
    }

    public String getMessage(String code, Object[] args) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, args, this.getDefaultLocale());
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.messageSource.getMessage(resolvable, this.getDefaultLocale());
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(resolvable, locale);
    }
}

