/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.context.weaving;

import com.att.aft.dme2.internal.apache.commons.logging.Log;
import com.att.aft.dme2.internal.apache.commons.logging.LogFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanClassLoaderAware;
import com.att.aft.dme2.internal.springframework.beans.factory.DisposableBean;
import com.att.aft.dme2.internal.springframework.instrument.classloading.InstrumentationLoadTimeWeaver;
import com.att.aft.dme2.internal.springframework.instrument.classloading.LoadTimeWeaver;
import com.att.aft.dme2.internal.springframework.instrument.classloading.ReflectiveLoadTimeWeaver;
import com.att.aft.dme2.internal.springframework.instrument.classloading.glassfish.GlassFishLoadTimeWeaver;
import com.att.aft.dme2.internal.springframework.instrument.classloading.jboss.JBossLoadTimeWeaver;
import com.att.aft.dme2.internal.springframework.instrument.classloading.tomcat.TomcatLoadTimeWeaver;
import com.att.aft.dme2.internal.springframework.instrument.classloading.weblogic.WebLogicLoadTimeWeaver;
import com.att.aft.dme2.internal.springframework.instrument.classloading.websphere.WebSphereLoadTimeWeaver;
import java.lang.instrument.ClassFileTransformer;

public class DefaultContextLoadTimeWeaver
implements LoadTimeWeaver,
BeanClassLoaderAware,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private LoadTimeWeaver loadTimeWeaver;

    public DefaultContextLoadTimeWeaver() {
    }

    public DefaultContextLoadTimeWeaver(ClassLoader beanClassLoader) {
        this.setBeanClassLoader(beanClassLoader);
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        LoadTimeWeaver serverSpecificLoadTimeWeaver = this.createServerSpecificLoadTimeWeaver(classLoader);
        if (serverSpecificLoadTimeWeaver != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Determined server-specific load-time weaver: " + serverSpecificLoadTimeWeaver.getClass().getName());
            }
            this.loadTimeWeaver = serverSpecificLoadTimeWeaver;
        } else if (InstrumentationLoadTimeWeaver.isInstrumentationAvailable()) {
            this.logger.info("Found Spring's JVM agent for instrumentation");
            this.loadTimeWeaver = new InstrumentationLoadTimeWeaver(classLoader);
        } else {
            try {
                this.loadTimeWeaver = new ReflectiveLoadTimeWeaver(classLoader);
                this.logger.info("Using a reflective load-time weaver for class loader: " + this.loadTimeWeaver.getInstrumentableClassLoader().getClass().getName());
            }
            catch (IllegalStateException ex) {
                throw new IllegalStateException(ex.getMessage() + " Specify a custom LoadTimeWeaver or start your Java virtual machine with Spring's agent: -javaagent:org.springframework.instrument.jar");
            }
        }
    }

    protected LoadTimeWeaver createServerSpecificLoadTimeWeaver(ClassLoader classLoader) {
        String name = classLoader.getClass().getName();
        try {
            if (name.startsWith("weblogic")) {
                return new WebLogicLoadTimeWeaver(classLoader);
            }
            if (name.startsWith("org.glassfish")) {
                return new GlassFishLoadTimeWeaver(classLoader);
            }
            if (name.startsWith("com.att.aft.dme2.internal.apache.catalina")) {
                return new TomcatLoadTimeWeaver(classLoader);
            }
            if (name.startsWith("org.jboss")) {
                return new JBossLoadTimeWeaver(classLoader);
            }
            if (name.startsWith("com.ibm")) {
                return new WebSphereLoadTimeWeaver(classLoader);
            }
        }
        catch (IllegalStateException ex) {
            this.logger.info("Could not obtain server-specific LoadTimeWeaver: " + ex.getMessage());
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this.loadTimeWeaver instanceof InstrumentationLoadTimeWeaver) {
            this.logger.info("Removing all registered transformers for class loader: " + this.loadTimeWeaver.getInstrumentableClassLoader().getClass().getName());
            ((InstrumentationLoadTimeWeaver)this.loadTimeWeaver).removeTransformers();
        }
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.loadTimeWeaver.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.loadTimeWeaver.getInstrumentableClassLoader();
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return this.loadTimeWeaver.getThrowawayClassLoader();
    }
}

